/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.component;

import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Font;
import com.sun.lwuit.Image;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.FocusListener;

public class YTextArea
extends TextArea
implements FocusListener {
    private Image focusIcon = null;
    private Image unFocusIcon = null;
    private Command editCommand;
    public static final int COMMAND_EDIT = 300;

    public YTextArea(Image aFocusIcon, Image aUnFocusIcon) {
        this.setCellRenderer(false);
        this.getStyle().setBorder(null);
        this.addFocusListener(this);
        this.focusIcon = aFocusIcon;
        this.unFocusIcon = aUnFocusIcon;
        this.getStyle().setBgImage(this.unFocusIcon);
        this.editCommand = new Command(YkUiContext.strMgr.getString("edit"), 300);
        this.getStyle().setPadding(1, 7);
    }

    public void focusGained(Component c) {
        this.getStyle().setBgImage(this.focusIcon);
        this.getComponentForm().addCommand(this.editCommand, this.getComponentForm().getCommandCount());
    }

    public void focusLost(Component c) {
        this.getStyle().setBgImage(this.unFocusIcon);
        this.getComponentForm().removeCommand(this.editCommand);
    }

    public void handleEditCmd() {
        super.fireClicked();
    }

    protected boolean isSelectableInteraction() {
        return false;
    }

    public String getTextAt(int line) {
        String str = super.getTextAt(line);
        Font font = this.getStyle().getFont();
        if (font != null) {
            int w;
            int i;
            int lineWidth = this.getWidth() - this.getStyle().getPadding(1) - this.getStyle().getPadding(3) - this.getStyle().getMargin(1) - this.getStyle().getMargin(3) - 10;
            for (i = 0; i < str.length() && (w = font.substringWidth(str, 0, i)) <= lineWidth; ++i) {
            }
            String sub = str;
            if (i < str.length()) {
                sub = str.substring(0, i - 1) + "...";
            }
            return sub;
        }
        return str;
    }
}

