/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.ykjc.ui.pages;

import com.fw.j2me.util.CntEvent;
import com.sonyericsson.ykjc.model.Channel;
import com.sonyericsson.ykjc.model.VideoInfo;
import com.sonyericsson.ykjc.ui.YkUiContext;
import com.sonyericsson.ykjc.ui.component.ChannelsBar;
import com.sonyericsson.ykjc.ui.component.ClipBrowserListener;
import com.sonyericsson.ykjc.ui.component.FinishedVideoRender;
import com.sonyericsson.ykjc.ui.component.Seperator;
import com.sonyericsson.ykjc.ui.component.VideoList;
import com.sonyericsson.ykjc.ui.component.YForm;
import com.sonyericsson.ykjc.ui.component.YNotice;
import com.sonyericsson.ykjc.ui.pages.YkPageBase;
import com.sonyericsson.ykjc.util.YkContentHandlerUtil;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Font;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;

public class PageRelative
extends YkPageBase
implements ClipBrowserListener,
FocusListener {
    private static final int COMMAND_PLAY = 1;
    private static final int COMMAND_UP = 2;
    private static final int COMMAND_DOWN = 3;
    private static final int COMMAND_REPLAY = 4;
    private static final int COMMAND_MYYOUKU = 5;
    private static final int COMMAND_LOGOUT = 6;
    private static final int COMMAND_SELECT = 7;
    private static final int COMMAND_SHARE = 8;
    private static final int COMMAND_HELP = 9;
    private Command cmdPlay = new Command(YkUiContext.strMgr.getString("play"), 1);
    private Command cmdReplay = new Command(YkUiContext.strMgr.getString("replay"), 4);
    private Command cmdUp = new Command(YkUiContext.strMgr.getString("up_menu"), 2);
    private Command cmdDown = new Command(YkUiContext.strMgr.getString("down_menu"), 3);
    private Command cmdMyyouku = new Command(YkUiContext.strMgr.getString("myYouku"), 5);
    private Command cmdLogout = new Command(YkUiContext.strMgr.getString("logout"), 6);
    private Command cmdSelect = new Command(YkUiContext.strMgr.getString("select"), 7);
    private Command cmdShare = new Command(YkUiContext.strMgr.getString("share_menu"), 8);
    private Command cmdHelp = new Command(YkUiContext.strMgr.getString("help"), 9);
    private VideoInfo seedVideo;
    private int currentRelateVideoIndex;
    private VideoInfo[] relateVideoList;
    private VideoList browser;
    private ChannelsBar chsBar;
    private FinishedVideoRender fr;

    public PageRelative(int pageId, VideoInfo seed) {
        super(pageId);
        this.seedVideo = seed;
        this.relateVideoList = YkUiContext.proxy.getRelativeList();
    }

    public void buildPageCommand() {
        this.form.removeAllCommands();
        if (this.browser != null && this.browser.hasFocus()) {
            this.form.addCommand(this.cmdPlay);
        } else if (this.chsBar != null && this.chsBar.hasFocus()) {
            this.form.addCommand(this.cmdSelect);
        } else {
            this.form.addCommand(this.cmdReplay);
        }
        this.form.addCommand(this.cmdBack);
        if (YkUiContext.proxy.getLoginStatus()) {
            this.form.addCommand(this.cmdLogout);
        }
        this.form.addCommand(this.cmdHelp);
        this.form.addCommand(this.cmdMyyouku);
        if (!(this.browser != null && this.browser.hasFocus() || this.chsBar.hasFocus())) {
            if (this.seedVideo.isCommentable()) {
                this.form.addCommand(this.cmdDown);
                this.form.addCommand(this.cmdUp);
            }
            this.form.addCommand(this.cmdShare);
        }
    }

    protected void buildPageContent() {
        this.form.removeAll();
        this.form.setLayout(new BoxLayout(2));
        this.form.getStyle().setBgImage(YkUiContext.imgMgr.getImage("relateVideoBg"));
        Channel[] channels = YkUiContext.proxy.listChannel();
        int barHeight = 25;
        this.chsBar = new ChannelsBar(new Dimension(YkPageBase.getScreenWidth(), barHeight), channels, this);
        this.chsBar.setFocusable(channels.length > 0);
        this.chsBar.setIsTop(true);
        ((YForm)this.form).addIndependentComponents(this.chsBar);
        this.form.addComponent(this.chsBar);
        this.form.addComponent(new Seperator());
        this.fr = new FinishedVideoRender(this.seedVideo, this.form);
        this.form.addComponent(this.fr);
        this.form.addComponent(new Seperator());
        if (this.relateVideoList != null && this.relateVideoList.length > 0) {
            Label relative = new Label(YkUiContext.strMgr.getString("relative"));
            relative.setFocusable(false);
            relative.getStyle().setPadding(0, 0, 0, 0);
            Font labelFont = Font.createSystemFont(32, 0, 8);
            relative.getStyle().setFont(labelFont);
            this.form.addComponent(relative);
            this.browser = new VideoList(this.relateVideoList);
            this.browser.addFocusListener(this);
            this.currentRelateVideoIndex = this.browser.getCurrentSelectClip();
            this.browser.setListener(this);
            ((YForm)this.form).addIndependentComponents(this.browser);
            this.form.addComponent(this.browser);
        } else {
            Label relative = new Label(YkUiContext.strMgr.getString("noRelativeVideo"));
            relative.setAlignment(4);
            relative.getStyle().setMargin(0, 50);
            relative.setFocusable(false);
            relative.getStyle().setPadding(0, 0, 0, 0);
            this.form.addComponent(relative);
        }
    }

    public void doActionPerformed(ActionEvent evt) {
        Command cmd = evt.getCommand();
        switch (cmd.getId()) {
            case 1: {
                this.playVideo(this.relateVideoList[this.currentRelateVideoIndex]);
                break;
            }
            case 4: {
                this.playVideo(this.seedVideo);
                break;
            }
            case 2: {
                this.doComment(true);
                break;
            }
            case 3: {
                this.doComment(false);
                break;
            }
            case 0: {
                this.changePage(0x10000000);
                break;
            }
            case 5: {
                this.doActionMyYoukuOption();
                break;
            }
            case 6: {
                this.doActionLogoutOption();
                this.buildPageCommand();
                break;
            }
            case 8: {
                YkContentHandlerUtil.shareViaSms(this.seedVideo.getVideoUrl());
                break;
            }
            case 9: {
                this.changePage(5);
                break;
            }
        }
    }

    private void doComment(boolean up) {
        YkUiContext.proxy.doComment(this.seedVideo, up);
        this.form.removeCommand(this.cmdUp);
        this.form.removeCommand(this.cmdDown);
        YNotice.showNotice(26, new Boolean(up));
    }

    public void selectClipChanged(int selectIndex) {
        this.currentRelateVideoIndex = selectIndex;
    }

    public void focusGained(Component c) {
        this.buildPageCommand();
    }

    public void focusLost(Component c) {
        this.buildPageCommand();
    }

    public boolean handleEvent(CntEvent event) {
        boolean handle = false;
        if (event == null) {
            return handle;
        }
        int type = event.getEventType();
        switch (type) {
            case 100: {
                String videoId = event.getAttrString(100);
                if (this.relateVideoList != null) {
                    for (int i = 0; i < this.relateVideoList.length; ++i) {
                        VideoInfo info = this.relateVideoList[i];
                        if (!info.getId().equals(videoId)) continue;
                        if (this.browser != null) {
                            this.browser.setVideo(info, i);
                            this.browser.repaint();
                        }
                        handle = true;
                    }
                }
                if (!this.seedVideo.getId().equals(videoId)) break;
                this.fr.setImage(this.seedVideo.getImg());
                this.fr.repaint();
                break;
            }
            case 8: {
                this.fr.updateComment();
                break;
            }
        }
        return handle;
    }

    public void cleanup() {
        this.chsBar.stopTimer();
    }

    public void refresh() {
        super.refresh();
        this.buildPageCommand();
        this.chsBar.startTimer();
    }
}

