/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.kx.invoc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;

public class Tool {
    public static int IDATPOS;
    public static byte[] HEADChunk;
    public static byte[] tRNSChunk;
    public static byte[] IENDChunk;
    public static int[] crc_table;

    static {
        HEADChunk = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        byte[] byArray = new byte[13];
        byArray[3] = 1;
        byArray[4] = 116;
        byArray[5] = 82;
        byArray[6] = 78;
        byArray[7] = 83;
        byArray[9] = 64;
        byArray[10] = -26;
        byArray[11] = -40;
        byArray[12] = 102;
        tRNSChunk = byArray;
        byte[] byArray2 = new byte[12];
        byArray2[4] = 73;
        byArray2[5] = 69;
        byArray2[6] = 78;
        byArray2[7] = 68;
        byArray2[8] = -82;
        byArray2[9] = 66;
        byArray2[10] = 96;
        byArray2[11] = -126;
        IENDChunk = byArray2;
    }

    public static byte[] Image2Bytes(Image img) {
        try {
            int w = img.getWidth();
            int h = img.getHeight();
            int offset = 0;
            byte[] buffer = new byte[(w * 4 + 1) * h + offset];
            Tool.getImageBufferForImageARGB8888(img, buffer, w, h, offset);
            System.gc();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(baos);
            Tool.WritePng(dout, w, h, buffer, null, false, offset);
            byte[] data = baos.toByteArray();
            Tool.writeCRC(data, 8);
            Tool.writeCRC(data, 33);
            Tool.writeCRC(data, IDATPOS);
            buffer = null;
            System.gc();
            return data;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void writeCRC(byte[] data, int chunkpos) {
        int sum;
        int chunklen = (data[chunkpos] & 0xFF) << 24 | (data[chunkpos + 1] & 0xFF) << 16 | (data[chunkpos + 2] & 0xFF) << 8 | data[chunkpos + 3] & 0xFF;
        int val = sum = ~Tool.CRCChecksum(data, chunkpos + 4, 4 + chunklen);
        int pos = chunkpos + 8 + chunklen;
        data[pos] = (byte)((val & 0xFF000000) >> 24);
        data[pos + 1] = (byte)((val & 0xFF0000) >> 16);
        data[pos + 2] = (byte)((val & 0xFF00) >> 8);
        data[pos + 3] = (byte)(val & 0xFF);
    }

    public static int CRCChecksum(byte[] buf, int off, int len) {
        int c = -1;
        if (crc_table == null) {
            crc_table = new int[256];
            int mkn = 0;
            while (mkn < 256) {
                int mkc = mkn;
                int mkk = 0;
                while (mkk < 8) {
                    mkc = (mkc & 1) == 1 ? 0xEDB88320 ^ mkc >>> 1 : (mkc >>>= 1);
                    ++mkk;
                }
                Tool.crc_table[mkn] = mkc;
                ++mkn;
            }
        }
        int n = off;
        while (n < len + off) {
            c = crc_table[(c ^ buf[n]) & 0xFF] ^ c >>> 8;
            ++n;
        }
        return c;
    }

    public static long adler32(long adler, byte[] buf, int index, int len) {
        int BASE = 65521;
        int NMAX = 5552;
        if (buf == null) {
            return 1L;
        }
        long s1 = adler & 0xFFFFL;
        long s2 = adler >> 16 & 0xFFFFL;
        while (len > 0) {
            int k = len < NMAX ? len : NMAX;
            len -= k;
            while (k >= 16) {
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                s2 += (s1 += (long)(buf[index++] & 0xFF));
                k -= 16;
            }
            if (k != 0) {
                do {
                    s2 += (s1 += (long)(buf[index++] & 0xFF));
                } while (--k != 0);
            }
            s1 %= (long)BASE;
            s2 %= (long)BASE;
        }
        return s2 << 16 | s1;
    }

    public static void WritePng(DataOutputStream output, int width, int height, byte[] buffer, byte[] colors, boolean Transparent, int offset) throws IOException {
        int adler = (int)Tool.adler32(1L, buffer, offset, buffer.length - offset);
        byte[] byArray = new byte[5];
        byArray[1] = -6;
        byArray[2] = 126;
        byArray[3] = 5;
        byArray[4] = -127;
        byte[] lenNlen = byArray;
        IDATPOS = 0;
        ((OutputStream)output).write(HEADChunk);
        IDATPOS += HEADChunk.length;
        output.writeInt(13);
        output.writeInt(1229472850);
        output.writeInt(width);
        output.writeInt(height);
        output.writeByte(8);
        if (colors == null) {
            output.writeByte(6);
        } else {
            output.writeByte(3);
        }
        output.writeByte(0);
        output.writeByte(0);
        output.writeByte(0);
        output.writeInt(0);
        IDATPOS += 25;
        if (colors != null) {
            output.writeInt(colors.length);
            output.writeInt(1347179589);
            ((OutputStream)output).write(colors);
            output.writeInt(0);
            IDATPOS += colors.length + 12;
        }
        if (Transparent) {
            ((OutputStream)output).write(tRNSChunk);
            IDATPOS += tRNSChunk.length;
        }
        byte[] dpixels = buffer;
        int bufferlen = dpixels.length - offset;
        int blocklen = 32506;
        int blocknum = 1;
        blocknum = dpixels.length % blocklen == 0 ? bufferlen / blocklen : bufferlen / blocklen + 1;
        int IDATChunkLen = bufferlen + 6 + blocknum * 5;
        output.writeInt(IDATChunkLen);
        output.writeInt(1229209940);
        output.writeShort(30938);
        int i = 0;
        while (i < blocknum) {
            int off = i * blocklen;
            int len = bufferlen - off;
            if (len >= blocklen) {
                len = blocklen;
                lenNlen[0] = 0;
            } else {
                lenNlen[0] = 1;
            }
            int msb = len & 0xFF;
            int lsb = len >>> 8;
            lenNlen[1] = (byte)msb;
            lenNlen[2] = (byte)lsb;
            lenNlen[3] = (byte)(msb ^ 0xFF);
            lenNlen[4] = (byte)(lsb ^ 0xFF);
            ((OutputStream)output).write(lenNlen);
            output.write(dpixels, off + offset, len);
            ++i;
        }
        output.writeInt(adler);
        output.writeInt(0);
        ((OutputStream)output).write(IENDChunk);
    }

    public static void getImageBufferForImageARGB8888(Image img, byte[] rawByte, int w, int h, int off) {
        int n = off;
        int[] raw = new int[w];
        int j = 0;
        while (j < h) {
            img.getRGB(raw, 0, w, 0, j, w, 1);
            int i = 0;
            while (i < raw.length) {
                int ARGB = raw[i];
                int a = (ARGB & 0xFF000000) >> 24;
                int r = (ARGB & 0xFF0000) >> 16;
                int g = (ARGB & 0xFF00) >> 8;
                int b = ARGB & 0xFF;
                if (i % w == 0) {
                    ++n;
                }
                rawByte[n] = (byte)r;
                rawByte[n + 1] = (byte)g;
                rawByte[n + 2] = (byte)b;
                rawByte[n + 3] = (byte)a;
                n += 4;
                ++i;
            }
            ++j;
        }
        raw = null;
        System.gc();
    }
}

