/*
 * Decompiled with CFR 0.152.
 */
package com.sina.ui;

import com.sina.ui.ComboBoxListener;
import com.sina.ui.ControlItem;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ComboBoxItem
extends ControlItem {
    public String[] title;
    public int selectedId;
    public Image[] imageList;
    public String[] textList;
    public int itemwidth;
    public int comboxWidth = 12;
    public int comboxHeight;
    public int titleHeight;
    public ComboBoxListener listener;

    public ComboBoxItem(String s, ComboBoxListener listener1) {
        this.width = G.W - 10;
        this.title = Tools.stringFormatArray(s, this.width, G.SHOW_FONT);
        this.itemwidth = this.width - this.comboxWidth;
        this.selectedId = 0;
        this.listener = listener1;
        this.update();
    }

    public void update() {
        this.titleHeight = this.title.length * G.SYS_FONTLINE_HEIGHT + 2;
        this.comboxHeight = G.SYS_FONTLINE_HEIGHT + 2;
        this.height = this.titleHeight + G.SYS_FONTLINE_HEIGHT + 3;
    }

    public void paint(Graphics g, int clipx, int clipy) {
        int offy = this.painty;
        g.setColor(G.ComboTxtColor);
        int i = 0;
        while (i < this.title.length) {
            g.drawString(this.title[i], this.paintx, offy + i * G.SYS_FONTLINE_HEIGHT, 20);
            ++i;
        }
        offy += this.titleHeight;
        if (this.focus) {
            g.setColor(G.ComboBackColor);
            g.fillRect(this.paintx + 2, offy + 2, this.itemwidth - 3, this.comboxHeight - 3);
        }
        g.setColor(G.ComboBackBorder);
        g.drawRect(this.paintx, offy, this.itemwidth, this.comboxHeight);
        this.drawMark(g, this.paintx + this.itemwidth - 1, offy + 2, this.comboxHeight - 3);
        if (this.focus) {
            g.setColor(G.ComboTxtSelectColor);
        } else {
            g.setColor(G.ComboTxtColor);
        }
        if (this.textList != null) {
            if (this.imageList != null && this.imageList[this.selectedId] != null) {
                g.drawImage(this.imageList[this.selectedId], this.paintx + 1, offy + 1, 20);
                g.drawString(this.textList[this.selectedId], this.paintx + 20, offy + 1, 20);
            } else {
                g.drawString(this.textList[this.selectedId], this.paintx + 2, offy + 1, 20);
            }
        }
    }

    private void drawMark(Graphics g, int x, int y, int height1) {
        g.setColor(G.ComboBackBorder);
        g.fillRect(x - height1, y, height1, height1);
        g.setColor(G.MenuSelectColor);
        int h = height1 / 2;
        int offy = y + h / 2;
        int i = 0;
        while (i < h - 1) {
            g.drawLine(x - h - i, offy + h - i, x - h + i, offy + h - i);
            ++i;
        }
    }

    public void doEntry() {
        this.listener.openComboBoxList(this);
    }
}

