/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.data;

import com.sina.http.HttpEngine;
import com.sina.http.HttpListener;
import com.sina.http.URLEncoder;
import com.sina.parser.xml.XMLDataBlock;
import com.sina.parser.xml.XMLDataListener;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.data.Account;
import com.sonyericsson.sina.widget.SinawidgetMIDlet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class AccountListModel
implements XMLDataListener,
HttpListener {
    public Vector account = new Vector();
    private ClientManager cm;
    private Account loginAccount;
    private int currentID;

    public AccountListModel(ClientManager cm) {
        this.cm = cm;
        this.loadAccountList();
    }

    private void loadAccountList() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"sinaweiboaccount", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.closeRecordStore();
                return;
            }
            RecordEnumeration recordenumeration = recordStore.enumerateRecords(null, null, false);
            while (recordenumeration.hasNextElement()) {
                Account user = new Account();
                user.rmsID = recordenumeration.nextRecordId();
                ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(recordStore.getRecord(user.rmsID));
                DataInputStream datainputstream = new DataInputStream(bytearrayinputstream);
                user.uid = datainputstream.readUTF();
                user.accountID = datainputstream.readUTF();
                user.pass = datainputstream.readUTF();
                user.gsid = datainputstream.readUTF();
                user.nick = datainputstream.readUTF();
                user.md5 = datainputstream.readUTF();
                user.url = datainputstream.readUTF();
                user.isFull = datainputstream.readBoolean();
                datainputstream.close();
                datainputstream = null;
                this.account.addElement(user);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addAccount(Account user) {
        int i = 0;
        while (i < this.account.size()) {
            if (((Account)this.account.elementAt((int)i)).accountID.equals(user.accountID)) {
                return;
            }
            ++i;
        }
        this.insertAccount(user);
        this.account.insertElementAt(user, 0);
    }

    private void insertAccount(Account user) {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
        try {
            dataoutputstream.writeUTF(user.uid);
            dataoutputstream.writeUTF(user.accountID);
            dataoutputstream.writeUTF(user.pass);
            if (user.gsid != null) {
                dataoutputstream.writeUTF(user.gsid);
            } else {
                dataoutputstream.writeUTF("");
            }
            if (user.nick != null) {
                dataoutputstream.writeUTF(user.nick);
            } else {
                dataoutputstream.writeUTF("");
            }
            if (user.md5 != null) {
                dataoutputstream.writeUTF(user.md5);
            } else {
                dataoutputstream.writeUTF("");
            }
            if (user.url != null) {
                dataoutputstream.writeUTF(user.url);
            } else {
                dataoutputstream.writeUTF("");
            }
            dataoutputstream.writeBoolean(user.isFull);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] abyte0 = bytearrayoutputstream.toByteArray();
        try {
            bytearrayoutputstream.close();
            bytearrayoutputstream = null;
            RecordStore recordStore = RecordStore.openRecordStore((String)"sinaweiboaccount", (boolean)true);
            user.rmsID = recordStore.addRecord(abyte0, 0, abyte0.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void login(String phoneid, String psw) {
        this.loginAccount = new Account();
        this.loginAccount.accountID = phoneid;
        this.loginAccount.pass = psw;
        this.loginAccount.makeMd5();
        StringBuffer send = new StringBuffer();
        send.append("u=");
        send.append(URLEncoder.encode(phoneid, "UTF-8"));
        send.append("&p=");
        send.append(psw);
        send.append("&c=java&s=");
        send.append(this.loginAccount.md5);
        this.cm.httpEngine.HttpConnect(0, 0, String.valueOf(G.serverPath) + "login.php?" + send.toString(), null, this, HttpEngine.HIGH);
        this.cm.setWait(true);
    }

    public void edituserinfo(String nick, int gender) {
        this.cm.currentAccount.nick = nick;
        StringBuffer send = new StringBuffer();
        send.append("sid=");
        send.append(this.cm.currentAccount.sessionID);
        send.append("&gsid=");
        send.append(this.cm.currentAccount.gsid);
        send.append("&gender=");
        send.append(gender);
        send.append("&nick=");
        this.cm.httpEngine.HttpConnect(1, 0, String.valueOf(G.serverPath) + "edituserinfo.php?" + send.toString() + URLEncoder.encode(nick, "UTF-8"), null, this, HttpEngine.HIGH);
        this.cm.setWait(true);
    }

    public boolean blockArrived(XMLDataBlock data) {
        block38: {
            if (this.currentID == 0) {
                block37: {
                    if (data.getTagName().equals("rss")) break block37;
                    return false;
                }
                try {
                    Vector childvc = data.getChildBlocks();
                    boolean re = true;
                    String errstr = null;
                    if (childvc != null) {
                        int i = 0;
                        while (i < childvc.size()) {
                            XMLDataBlock item = (XMLDataBlock)childvc.elementAt(i);
                            if (item.getTagName().equals("gsid")) {
                                this.loginAccount.gsid = item.getText();
                            } else if (item.getTagName().equals("errno")) {
                                re = false;
                            } else if (item.getTagName().equals("errmsg")) {
                                errstr = item.getText();
                            } else if (item.getTagName().equals("sid")) {
                                this.loginAccount.sessionID = item.getText();
                            } else if (item.getTagName().equals("status")) {
                                this.loginAccount.isFull = "1".equals(item.getText());
                            } else if (item.getTagName().equals("nick")) {
                                this.loginAccount.nick = item.getText();
                            } else if (item.getTagName().equals("uid")) {
                                this.loginAccount.uid = item.getText();
                            } else if (item.getTagName().equals("url")) {
                                this.loginAccount.url = item.getText();
                            }
                            item.close();
                            ++i;
                        }
                    }
                    data.close();
                    if (re) {
                        this.addAccount(this.loginAccount);
                        this.cm.back(true);
                    } else {
                        this.cm.showAlert(errstr);
                    }
                    this.cm.setWait(false);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
            if (data.getTagName().equals("rss")) break block38;
            return false;
        }
        try {
            Vector childvc = data.getChildBlocks();
            boolean re = false;
            String errstr = null;
            if (childvc != null) {
                int i = 0;
                while (i < childvc.size()) {
                    XMLDataBlock item = (XMLDataBlock)childvc.elementAt(i);
                    if (item.getTagName().equals("errno")) {
                        re = false;
                    } else if (item.getTagName().equals("errmsg")) {
                        errstr = item.getText();
                    } else if (item.getTagName().equals("sid")) {
                        this.cm.currentAccount.sessionID = item.getText();
                    } else if (item.getTagName().equals("result")) {
                        re = "1".equals(item.getText());
                    }
                    item.close();
                    ++i;
                }
            }
            data.close();
            if (re) {
                this.cm.currentAccount.isFull = true;
                this.cm.changeStageWithId(7, 3, -1, false);
                this.updateCurentAccount();
            } else {
                this.cm.showAlert(errstr);
            }
            this.cm.setWait(false);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void updateCurentAccount() {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
        try {
            dataoutputstream.writeUTF(this.cm.currentAccount.uid);
            dataoutputstream.writeUTF(this.cm.currentAccount.accountID);
            dataoutputstream.writeUTF(this.cm.currentAccount.pass);
            if (this.cm.currentAccount.gsid != null) {
                dataoutputstream.writeUTF(this.cm.currentAccount.gsid);
            } else {
                dataoutputstream.writeUTF("");
            }
            if (this.cm.currentAccount.nick != null) {
                dataoutputstream.writeUTF(this.cm.currentAccount.nick);
            } else {
                dataoutputstream.writeUTF("");
            }
            if (this.cm.currentAccount.md5 != null) {
                dataoutputstream.writeUTF(this.cm.currentAccount.md5);
            } else {
                dataoutputstream.writeUTF("");
            }
            if (this.cm.currentAccount.url != null) {
                dataoutputstream.writeUTF(this.cm.currentAccount.url);
            } else {
                dataoutputstream.writeUTF("");
            }
            dataoutputstream.writeBoolean(this.cm.currentAccount.isFull);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] abyte0 = bytearrayoutputstream.toByteArray();
        try {
            bytearrayoutputstream.close();
            bytearrayoutputstream = null;
            RecordStore recordStore = RecordStore.openRecordStore((String)"sinaweiboaccount", (boolean)true);
            recordStore.setRecord(this.cm.currentAccount.rmsID, abyte0, 0, abyte0.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handleHttpError(int httpid, String errostr) {
        this.cm.showAlert("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff01\u8bf7\u5c1d\u8bd5\u5728\u5e10\u6237\u9875\u91cd\u7f6e\u7f51\u7edc\u3002");
        this.cm.setWait(false);
    }

    public boolean receiveHttpResponse(int httpid, int type, byte[] dis) {
        try {
            this.currentID = httpid;
            return this.cm.xmlEngine.receiveHttpResponse(dis, this);
        }
        catch (IOException e) {
            return false;
        }
    }

    public void deleteAll() {
        int i = 0;
        while (i < this.account.size()) {
            this.deleteData(i);
            ++i;
        }
    }

    private void deleteData(int i) {
        Account user = (Account)this.account.elementAt(i);
        this.account.removeElementAt(i);
        try {
            this.cm.updateView(7, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            SinawidgetMIDlet.instance.deleteUser(user.gsid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            RecordStore.deleteRecordStore((String)user.accountID);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            RecordStore.deleteRecordStore((String)("HEAD" + user.accountID));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void delete(int i) {
        Account user = (Account)this.account.elementAt(i);
        this.account.removeElementAt(i);
        try {
            this.cm.updateView(7, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            SinawidgetMIDlet.instance.deleteUser(user.gsid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"sinaweiboaccount", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.closeRecordStore();
                return;
            }
            recordStore.deleteRecord(user.rmsID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            RecordStore.deleteRecordStore((String)user.accountID);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            RecordStore.deleteRecordStore((String)("HEAD" + user.accountID));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

