/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.data;

import com.sina.http.HttpEngine;
import com.sina.http.HttpListener;
import com.sina.http.URLEncoder;
import com.sina.parser.xml.XMLDataBlock;
import com.sina.parser.xml.XMLDataListener;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.data.Account;
import com.sina.weibo.data.AccountListModel;
import com.sina.weibo.data.AtListModel;
import com.sina.weibo.data.Bowen;
import com.sina.weibo.data.BowenListModel;
import com.sina.weibo.data.CommentListModel;
import com.sina.weibo.data.HuatiBowenListModel;
import com.sina.weibo.data.MyBlogModel;
import com.sina.weibo.data.PinglunListModel;
import com.sina.weibo.data.SearchAccountListModel;
import com.sina.weibo.data.Sixin;
import com.sina.weibo.data.SixinListModel;
import com.sina.weibo.data.SuibianListModel;
import com.sina.weibo.data.TuijianAccountListModel;
import com.sina.weibo.data.UserBowenListModel;
import com.sina.weibo.data.UserSixinListModel;
import com.sina.weibo.data.WebAccountListModel;
import java.util.Vector;

public class DataManager
implements HttpListener,
XMLDataListener {
    private static DataManager instance;
    private BowenListModel bowenListModel;
    private AccountListModel accountListModel;
    private AtListModel atListModel;
    private SuibianListModel suibianListModel;
    private WebAccountListModel fensiList;
    private WebAccountListModel guanzhuList;
    private SuibianListModel remenListModel;
    private TuijianAccountListModel tuijianAccount;
    private SixinListModel sixinListModel;
    private MyBlogModel myBlogModel;
    private PinglunListModel pinglunListModel;

    private DataManager() {
    }

    public BowenListModel getBowenListModel() {
        if (ClientManager.getInstance().currentAccount == null) {
            ClientManager.getInstance().currentAccount = new Account();
            ClientManager.getInstance().currentAccount.sessionID = "session";
            ClientManager.getInstance().currentAccount.gsid = "111111111111";
            ClientManager.getInstance().currentAccount.accountID = "1111111111";
        }
        if (this.bowenListModel == null || this.bowenListModel.owner == null || !this.bowenListModel.owner.equals(ClientManager.getInstance().currentAccount.accountID)) {
            this.bowenListModel = new BowenListModel(ClientManager.getInstance());
        }
        return this.bowenListModel;
    }

    public void addBowen(String bowen, byte[] pic) {
        this.getBowenListModel().addBowen(bowen, pic);
    }

    public AccountListModel getAccountListModel() {
        if (this.accountListModel == null) {
            this.accountListModel = new AccountListModel(ClientManager.getInstance());
        }
        return this.accountListModel;
    }

    public WebAccountListModel getAccountListModel(int i) {
        if (i == 0) {
            if (this.guanzhuList == null || !ClientManager.getInstance().currentAccount.accountID.equals(this.guanzhuList.accountID)) {
                this.guanzhuList = new WebAccountListModel(ClientManager.getInstance(), i);
            }
            return this.guanzhuList;
        }
        if (this.fensiList == null || !ClientManager.getInstance().currentAccount.accountID.equals(this.fensiList.accountID)) {
            this.fensiList = new WebAccountListModel(ClientManager.getInstance(), i);
        }
        return this.fensiList;
    }

    public CommentListModel getCommentListModel(Bowen bowen) {
        return new CommentListModel(ClientManager.getInstance(), bowen);
    }

    public AtListModel getAtListModel() {
        if (this.atListModel == null || !this.atListModel.owner.equals(ClientManager.getInstance().currentAccount.accountID)) {
            this.atListModel = new AtListModel(ClientManager.getInstance());
        }
        return this.atListModel;
    }

    public SuibianListModel getSuibianListModel() {
        if (this.suibianListModel == null) {
            this.suibianListModel = new SuibianListModel(ClientManager.getInstance(), 1);
        }
        return this.suibianListModel;
    }

    public SuibianListModel getRemenListModel() {
        if (this.remenListModel == null) {
            this.remenListModel = new SuibianListModel(ClientManager.getInstance(), 2);
        }
        return this.remenListModel;
    }

    public UserBowenListModel getUserBowenList(Account account) {
        return new UserBowenListModel(ClientManager.getInstance(), account);
    }

    public void getUser(String value) {
        StringBuffer send = new StringBuffer();
        send.append("sid=");
        send.append(ClientManager.getInstance().currentAccount.sessionID);
        send.append("&gsid=");
        send.append(ClientManager.getInstance().currentAccount.gsid);
        send.append("&nick=");
        send.append(URLEncoder.encode(value, "UTF-8"));
        ClientManager.getInstance().httpEngine.HttpConnect(1, 0, String.valueOf(G.serverPath) + "getuserinfo.php?" + send.toString(), null, this, HttpEngine.HIGH);
        ClientManager.getInstance().setWait(true);
    }

    public void handleHttpError(int httpid, String errostr) {
        ClientManager.getInstance().showAlert("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff01\u8bf7\u5c1d\u8bd5\u5728\u5e10\u6237\u9875\u91cd\u7f6e\u7f51\u7edc\u3002");
        ClientManager.getInstance().setWait(false);
    }

    public boolean receiveHttpResponse(int httpid, int type, byte[] dis) {
        try {
            return ClientManager.getInstance().xmlEngine.receiveHttpResponse(dis, this);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean blockArrived(XMLDataBlock data) {
        block22: {
            if (data.getTagName().equals("rss")) break block22;
            return false;
        }
        try {
            Account account = new Account();
            Vector childvc = data.getChildBlocks();
            if (childvc != null) {
                int i = 0;
                while (i < childvc.size()) {
                    XMLDataBlock itemdata = (XMLDataBlock)childvc.elementAt(i);
                    if (itemdata.getTagName().equals("nick")) {
                        account.nick = itemdata.getText();
                    } else if (itemdata.getTagName().equals("uid")) {
                        account.uid = itemdata.getText();
                    } else if (itemdata.getTagName().equals("attmenum")) {
                        account.fensishu = "\u7c89\u4e1d:" + itemdata.getText();
                    } else if (itemdata.getTagName().equals("relation")) {
                        try {
                            account.relation = Integer.parseInt(itemdata.getText());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (itemdata.getTagName().equals("gender")) {
                        account.sex = "0".equals(itemdata.getText()) ? "\u7537" : "\u5973";
                    } else if (itemdata.getTagName().equals("portrait")) {
                        account.headUrl = itemdata.getText();
                    } else if (itemdata.getTagName().equals("sid")) {
                        ClientManager.getInstance().currentAccount.sessionID = itemdata.getText();
                    }
                    itemdata.close();
                    ++i;
                }
            }
            data.close();
            ClientManager.getInstance().setWait(false);
            if (account.uid != null && !"".equals(account.uid)) {
                ClientManager.getInstance().changeStageWithObject(0, 13, account, false);
            } else {
                ClientManager.getInstance().showAlert("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff01");
            }
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public HuatiBowenListModel getHuatiBowenList(String title) {
        return new HuatiBowenListModel(ClientManager.getInstance(), title);
    }

    public TuijianAccountListModel getTuijianAccountModel() {
        if (this.tuijianAccount == null) {
            this.tuijianAccount = new TuijianAccountListModel(ClientManager.getInstance());
        }
        return this.tuijianAccount;
    }

    public SixinListModel getSixinListModel() {
        if (this.sixinListModel == null || !this.sixinListModel.owner.equals(ClientManager.getInstance().currentAccount.accountID)) {
            this.sixinListModel = new SixinListModel(ClientManager.getInstance());
        }
        return this.sixinListModel;
    }

    public UserSixinListModel getUserSixinModel(Sixin sixin) {
        return new UserSixinListModel(ClientManager.getInstance(), sixin);
    }

    public MyBlogModel getMyblogModel() {
        if (this.myBlogModel == null || !this.myBlogModel.owner.equals(ClientManager.getInstance().currentAccount.accountID)) {
            this.myBlogModel = new MyBlogModel(ClientManager.getInstance());
        }
        return this.myBlogModel;
    }

    public SearchAccountListModel getSearchUserList(String key) {
        return new SearchAccountListModel(ClientManager.getInstance(), key);
    }

    public PinglunListModel getPinglunListModel() {
        if (this.pinglunListModel == null || !this.pinglunListModel.owner.equals(ClientManager.getInstance().currentAccount.accountID)) {
            this.pinglunListModel = new PinglunListModel(ClientManager.getInstance());
        }
        return this.pinglunListModel;
    }

    public static DataManager getInstence() {
        if (instance == null) {
            instance = new DataManager();
        }
        return instance;
    }

    public void destroy() {
        this.atListModel = null;
        this.suibianListModel = null;
        this.fensiList = null;
        this.guanzhuList = null;
        this.remenListModel = null;
        this.tuijianAccount = null;
        this.sixinListModel = null;
        this.myBlogModel = null;
        this.pinglunListModel = null;
    }
}

