/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.view;

import com.sina.ui.BackItem;
import com.sina.ui.CommentListItem;
import com.sina.ui.InputBox;
import com.sina.ui.InputListener;
import com.sina.ui.ListItem;
import com.sina.ui.ListListener;
import com.sina.ui.ListRollContainer;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.data.Comment;
import com.sina.weibo.data.CommentListModel;
import com.sina.weibo.view.AbstractView;
import javax.microedition.lcdui.Graphics;

public class CommentListView
extends AbstractView
implements ListListener,
InputListener {
    private CommentListModel clm;

    public CommentListView(ClientManager cm, CommentListModel clm) {
        super(cm);
        this.viewID = 8;
        this.clm = clm;
        this.init();
    }

    public void keyPressed(int keyCode) {
        if (this.menu.isOpen) {
            this.menuKeyPressed(keyCode);
            return;
        }
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 7: {
                super.keyPressed(keyCode);
                break;
            }
            case 5: {
                if (!(this.list.getFocusItem() instanceof CommentListItem)) break;
                new InputBox("\u8bc4\u8bba\uff1a", "", 140, 0, this, 0);
                break;
            }
            case 6: {
                this.cm.back(false);
                break;
            }
            case 3: {
                this.cm.back(false);
                break;
            }
            case 1: {
                if (!this.list.movePre()) break;
                this.list.gotFocus((byte)1);
                break;
            }
            case 2: {
                if (!this.list.moveNext()) break;
                this.list.gotFocus((byte)0);
                break;
            }
            case 4: {
                this.list.doEntry();
            }
        }
    }

    public void destroy() {
    }

    public void paint(Graphics g) {
        this.lrc.paint(g);
        Tools.drawMenuBar(g, "\u56de\u590d", "\u8fd4\u56de", null);
    }

    private void init() {
        BackItem li = new BackItem("\u5f53\u524d\u7528\u6237\uff1a" + this.cm.currentAccount.nick);
        li.setPaintx(0);
        li.setPainty(0);
        li.setWidth(G.W);
        this.lrc.addItem(li);
        this.list = new ListRollContainer(G.W, G.H - li.getHeight() - G.MenuBarHeight);
        this.list.setPainty(li.getHeight());
        this.lrc.addItem(this.list);
        if (this.clm.commentLsit.size() > 0) {
            this.update(0);
        }
    }

    public void update(int type) {
        this.list.removeAll();
        if (this.clm != null && this.clm.commentLsit != null) {
            if (this.clm.pageId > 1) {
                ListItem li = new ListItem("\u4e0a\u4e00\u9875", -1, (ListListener)this, this.list, 1);
                this.list.addItem(li);
            }
            int i = 0;
            while (i < this.clm.commentLsit.size()) {
                CommentListItem li;
                Comment comment = (Comment)this.clm.commentLsit.elementAt(i);
                if (comment.content.length() < 100) {
                    li = new CommentListItem(comment.nick, comment.time, comment.content, i, this, this.list);
                    this.list.addItem(li);
                } else {
                    li = new CommentListItem(comment.nick, comment.time, String.valueOf(comment.content.substring(0, 100)) + "...", i, this, this.list);
                    this.list.addItem(li);
                }
                ++i;
            }
            if (this.clm.pageId < this.clm.pages) {
                ListItem li = new ListItem("\u4e0b\u4e00\u9875", -2, (ListListener)this, this.list, 1);
                this.list.addItem(li);
            }
            this.list.gotFocus((byte)1);
        }
        this.render();
    }

    public void listitemPressed(int id) {
        if (id < 0) {
            if (id == -1) {
                if (this.clm.pageId > 1) {
                    this.clm.getCommentList(--this.clm.pageId);
                }
            } else if (id == -2) {
                this.clm.getCommentList(++this.clm.pageId);
            }
        }
    }

    public void setText(String text, int id) {
        if (text == null || "".equals(text)) {
            this.cm.showAlert("\u8bc4\u8bba\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        this.clm.addComment(((CommentListItem)this.list.getFocusItem()).getID(), text);
    }
}

