/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.view;

import com.sina.file.FileNode;
import com.sina.ui.BackItem;
import com.sina.ui.ListItem;
import com.sina.ui.ListListener;
import com.sina.ui.ListRollContainer;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.view.AbstractView;
import com.sina.weibo.view.DirectoryListener;
import java.util.Enumeration;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LocalDirectoryView
extends AbstractView
implements ListListener {
    private FileNode fn;
    private Image directoryImage;
    private Image fileImage;
    private DirectoryListener listener;

    public LocalDirectoryView(ClientManager cm, DirectoryListener listener) {
        super(cm);
        this.viewID = 6;
        Enumeration e1 = FileSystemRegistry.listRoots();
        this.fn = new FileNode(null, null);
        while (e1.hasMoreElements()) {
            String diskName = (String)e1.nextElement();
            this.fn.child.addElement(new FileNode("file:///" + diskName, this.fn));
        }
        this.listener = listener;
        try {
            this.directoryImage = Image.createImage((String)"/file.PNG");
            this.fileImage = Image.createImage((String)"/text.PNG");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init();
    }

    public LocalDirectoryView(ClientManager cm, DirectoryListener listener, FileNode fn) {
        super(cm);
        this.viewID = 6;
        this.listener = listener;
        this.fn = fn;
        try {
            this.directoryImage = Image.createImage((String)"/file.PNG");
            this.fileImage = Image.createImage((String)"/text.PNG");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init();
    }

    public void keyPressed(int keyCode) {
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 6: {
                this.listener.cancel();
                break;
            }
            case 3: {
                super.keyPressed(keyCode);
                break;
            }
            case 1: {
                if (!this.list.movePre()) break;
                this.list.gotFocus((byte)1);
                break;
            }
            case 2: {
                if (!this.list.moveNext()) break;
                this.list.gotFocus((byte)0);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                this.list.doEntry();
            }
        }
    }

    public void destroy() {
    }

    private void init() {
        BackItem li = new BackItem("\u672c\u5730\u56fe\u7247");
        li.setPaintx(0);
        li.setPainty(0);
        li.setWidth(G.W);
        this.lrc.addItem(li);
        this.list = new ListRollContainer(G.W, G.H - li.getHeight() - G.MenuBarHeight);
        this.list.setPainty(li.getHeight());
        this.lrc.addItem(this.list);
        this.update(0);
    }

    public void update(int type) {
        this.list.removeAll();
        if (this.fn != null) {
            if (this.fn.parent != null) {
                ListItem li = new ListItem("..", -1, this, this.list);
                li.setIcon(this.directoryImage);
                li.setShowBack(false);
                this.list.addItem(li);
            }
            if (this.fn.child != null) {
                int i = 0;
                while (i < this.fn.child.size()) {
                    FileNode f = (FileNode)this.fn.child.elementAt(i);
                    ListItem li = new ListItem(f.name, i, this, this.list);
                    if (f.isDirectory) {
                        li.setIcon(this.directoryImage);
                    } else {
                        li.setIcon(this.fileImage);
                    }
                    li.setShowBack(false);
                    this.list.addItem(li);
                    ++i;
                }
            }
            this.list.gotFocus((byte)1);
        }
        this.render();
    }

    public void paint(Graphics g) {
        this.lrc.paint(g);
        Tools.drawMenuBar(g, "\u6253\u5f00", "\u8fd4\u56de", null);
    }

    public void listitemPressed(int id) {
        if (id >= 0) {
            FileNode f = (FileNode)this.fn.child.elementAt(id);
            if (f.isDirectory) {
                if (f.child.size() == 0) {
                    f.initChild();
                }
                this.fn = f;
                this.update(0);
            } else {
                this.listener.setPath(f.path);
            }
        } else {
            FileNode f = this.fn.parent;
            if (f != null) {
                this.fn = f;
                this.update(0);
            }
        }
    }
}

