/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.view;

import com.sina.ui.CommentListItem;
import com.sina.ui.HeadItem;
import com.sina.ui.HeadListener;
import com.sina.ui.InputBox;
import com.sina.ui.InputListener;
import com.sina.ui.ListItem;
import com.sina.ui.ListListener;
import com.sina.ui.ListRollContainer;
import com.sina.ui.MenuItem;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.data.Sixin;
import com.sina.weibo.data.UserSixinListModel;
import com.sina.weibo.view.AbstractView;

public class UserSixinListView
extends AbstractView
implements ListListener,
InputListener,
HeadListener {
    private UserSixinListModel blm;
    private String[] menuItems = new String[]{"\u56de\u4fe1", "\u8fdb\u5165\u535a\u4e3b\u9996\u9875"};

    public UserSixinListView(ClientManager cm, UserSixinListModel blm) {
        super(cm);
        this.viewID = 18;
        this.blm = blm;
        this.init();
    }

    public void doMenuItem(int id) {
        if (this.cm.currentAccount == null && id < 3) {
            this.cm.showRegAlert("\u53ea\u6709\u767b\u5f55\u7528\u6237\u624d\u80fd\u4f7f\u7528\u8be5\u529f\u80fd\uff01");
            this.closeMenuList();
            return;
        }
        switch (id) {
            case 0: {
                new InputBox("\u7ed9" + this.blm.sixin.nick + "\u56de\u4fe1\uff1a", "", 300, 0, this, 1);
                break;
            }
            case 1: {
                this.cm.getUser(this.blm.sixin.nick);
            }
        }
        this.closeMenuList();
    }

    public void keyPressed(int keyCode) {
        if (this.menu.isOpen) {
            this.menuKeyPressed(keyCode);
            return;
        }
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 5: 
            case 7: {
                super.keyPressed(keyCode);
                break;
            }
            case 6: {
                this.cm.back(false);
                break;
            }
            case 1: {
                if (!this.list.movePre()) break;
                this.list.gotFocus((byte)1);
                break;
            }
            case 2: {
                if (!this.list.moveNext()) break;
                this.list.gotFocus((byte)0);
            }
        }
    }

    public void destroy() {
    }

    private void init() {
        HeadItem head = new HeadItem(this.blm.sixin.headIcon, this.blm.sixin.nick, this.blm.sixin.time, "", "", (HeadListener)this);
        head.focuses[1] = true;
        this.lrc.addItem(head);
        this.list = new ListRollContainer(G.W, G.H - head.getHeight() - G.MenuBarHeight);
        this.list.setPainty(head.getHeight());
        this.lrc.addItem(this.list);
        this.update(0);
    }

    public void update(int type) {
        if (this.blm.sixinvc.size() > 0) {
            this.list.removeAll();
            if (this.blm != null && this.blm.sixinvc != null) {
                if (this.blm.pageId > 1) {
                    ListItem li = new ListItem("\u4e0a\u4e00\u9875", -1, (ListListener)this, this.list, 1);
                    this.list.addItem(li);
                }
                int i = 0;
                while (i < this.blm.sixinvc.size()) {
                    Sixin bowen = (Sixin)this.blm.sixinvc.elementAt(i);
                    CommentListItem li = new CommentListItem(bowen.shownick, bowen.time, bowen.content, i, this, this.list);
                    if (bowen.type == 0) {
                        li.setContentColor(10037248);
                    }
                    this.list.addItem(li);
                    ++i;
                }
                if (this.blm.count > this.blm.pagesize * this.blm.pageId) {
                    ListItem li = new ListItem("\u4e0b\u4e00\u9875", -2, (ListListener)this, this.list, 1);
                    this.list.addItem(li);
                }
            }
        }
        this.list.gotFocus((byte)1);
        this.render();
    }

    public void listitemPressed(int id) {
        if (id < 0) {
            if (id == -1) {
                if (this.blm.pageId > 1) {
                    this.blm.getSixinList(--this.blm.pageId);
                }
            } else if (id == -2) {
                this.blm.getSixinList(++this.blm.pageId);
            }
        }
    }

    public void setText(String text, int id) {
        if (text != null && !"".equals(text)) {
            this.blm.sendSixin(text);
        }
    }

    protected void showMenu() {
        if (this.menu.empty()) {
            int i = 0;
            while (i < this.menuItems.length) {
                MenuItem menuitem = new MenuItem(this.menuItems[i], i, this);
                this.menu.addItem(menuitem);
                ++i;
            }
        }
        this.openMenuList();
    }

    public void headClicked(int id) {
        if (id == 1) {
            this.cm.getUser(this.blm.sixin.nick);
        }
    }
}

