/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.sina.img;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.amms.GlobalManager;
import javax.microedition.amms.MediaProcessor;
import javax.microedition.amms.control.ImageFormatControl;
import javax.microedition.amms.control.imageeffect.ImageEffectControl;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Images {
    public static final Image ITEM_BG = Images.createImage("/widget/bg_item.png");
    public static final Image ITEM_BG_BLEND = Images.blendImage(ITEM_BG);
    public static final Image ITEM_BG_BLEND1 = Images.blurImage(ITEM_BG, true);
    public static final Image ITEM_BG_FOCUSED = Images.createImage("/widget/bg_item_focus.png");
    public static final Image LOGIN = Images.createImage("/widget/login.png");
    public static final Image LOADING = Images.createImage("/widget/loading.png");
    public static final Image DEFAULT = Images.createImage("/head.png");
    public static final Image DEFAULT_BLEND = Images.blendImage(DEFAULT);
    public static final Image PHOTO = Images.createImage("/pic.png");
    public static final Image PHOTO_BLEND = Images.blendImage(PHOTO);

    public static Image createImage(String path) {
        try {
            return Image.createImage((String)path);
        }
        catch (IOException localIOException) {
            localIOException.printStackTrace();
            return null;
        }
    }

    public static Image scaleImage(Image image, int newWidth, int newHeight) {
        int[] rawInput = new int[image.getHeight() * image.getWidth()];
        image.getRGB(rawInput, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int YD = image.getHeight() / newHeight * image.getWidth() - image.getWidth();
        int YR = image.getHeight() % newHeight;
        int XD = image.getWidth() / newWidth;
        int XR = image.getWidth() % newWidth;
        int outOffset = 0;
        int inOffset = 0;
        int y = newHeight;
        int YE = 0;
        while (y > 0) {
            int x = newWidth;
            int XE = 0;
            while (x > 0) {
                rawOutput[outOffset++] = rawInput[inOffset];
                inOffset += XD;
                if ((XE += XR) >= newWidth) {
                    XE -= newWidth;
                    ++inOffset;
                }
                --x;
            }
            inOffset += YD;
            if ((YE += YR) >= newHeight) {
                YE -= newHeight;
                inOffset += image.getWidth();
            }
            --y;
        }
        Image img = DirectUtils.createImage((int)newWidth, (int)newHeight, (int)0);
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)img.getGraphics());
        dg.drawPixels(rawOutput, true, 0, newWidth, 0, 0, newWidth, newHeight, 0, 8888);
        rawOutput = null;
        rawInput = null;
        return img;
    }

    public static Image makeMonoImage(Image in) {
        Image out = null;
        if (in == null) {
            System.out.println("null input image");
            return null;
        }
        try {
            MediaProcessor processor = GlobalManager.createMediaProcessor((String)"image/raw");
            processor.setInput((Object)in);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            processor.setOutput((OutputStream)os);
            ImageEffectControl imageEffect = (ImageEffectControl)processor.getControl("javax.microedition.amms.control.imageeffect.ImageEffectControl");
            if (imageEffect != null) {
                imageEffect.setPreset("monochrome");
            }
            imageEffect.setEnabled(true);
            ImageFormatControl format = (ImageFormatControl)processor.getControl("javax.microedition.amms.control.ImageFormatControl");
            format.setFormat("image/jpeg");
            format.setParameter("quality", 75);
            processor.complete();
            ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());
            out = Image.createImage((InputStream)bais);
            return out;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Image blendImage(Image image) {
        try {
            int[] rawInt = new int[image.getWidth() * image.getHeight()];
            image.getRGB(rawInt, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
            Images.blendIcon(rawInt, image.getWidth(), image.getHeight() - image.getWidth());
            Image out = Image.createRGBImage((int[])rawInt, (int)image.getWidth(), (int)image.getHeight(), (boolean)true);
            rawInt = null;
            return out;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Image blurImage(Image image, boolean blurAll) {
        try {
            int nWidth = image.getWidth();
            int nHeight = image.getHeight();
            int[] rawInt = new int[nWidth * nHeight];
            image.getRGB(rawInt, 0, nWidth, 0, 0, nWidth, nHeight);
            int alphaValue = -939524096;
            int i = 0;
            while (i < nHeight) {
                int nStart = i * nWidth;
                if (i < nWidth && !blurAll) {
                    alphaValue = -16777216;
                } else {
                    if (i == nWidth) {
                        alphaValue = -939524096;
                    }
                    if (i > nWidth) {
                        alphaValue -= 200 / (nHeight - nWidth - 1) << 24;
                    }
                }
                int j = 0;
                while (j < nWidth) {
                    int color = rawInt[nStart + j] & 0xFFFFFF;
                    rawInt[nStart + j] = color |= alphaValue;
                    ++j;
                }
                ++i;
            }
            Image out = Image.createRGBImage((int[])rawInt, (int)nWidth, (int)nHeight, (boolean)true);
            rawInt = null;
            return out;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void blend(int[] raw, int alphaValue, int maskColor, int dontmaskColor) {
        int len = raw.length;
        int i = 0;
        while (i < len) {
            int a = 0;
            int color = raw[i] & 0xFFFFFF;
            if (maskColor == color) {
                a = 0;
            } else if (dontmaskColor == color) {
                a = 255;
            } else if (alphaValue > 0) {
                a = alphaValue;
            }
            raw[i] = color += (a <<= 24);
            ++i;
        }
    }

    public static void blend(int[] raw, int alphaValue) {
        Images.blend(raw, alphaValue, -1, -1);
    }

    public static void blendIcon(int[] raw, int nWidth, int nFlipHeight) {
        int len = raw.length;
        int nHeight = len / nWidth;
        int alphaValue = 0x64000000;
        int i = 0;
        while (i < nHeight) {
            int nStart = i * nWidth;
            if (i > nWidth + 1) {
                alphaValue -= 100 / nFlipHeight << 24;
            }
            int j = 0;
            while (j < nWidth) {
                int color = raw[nStart + j] & 0xFFFFFF;
                raw[nStart + j] = color += alphaValue;
                ++j;
            }
            ++i;
        }
    }
}

