/*
 * Decompiled with CFR 0.152.
 */
package com.jw.http;

import com.jw.http.CmwapInputStream;
import com.sonyericsson.kx.KxMIDlet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.SocketConnection;

public class CmwapConnection
implements HttpConnection {
    private SocketConnection sc = null;
    String ContentLength = null;
    String ContentType = null;
    String UserAgent = "JoinWin Client 1.0";
    String Url = null;
    String responseHead = null;
    Hashtable headers = new Hashtable();
    boolean bCompress = false;
    String strRequestMode = "GET";
    String xonline = null;
    InputStream in;
    String response;

    public void setCompress(boolean compress) {
        this.bCompress = compress;
    }

    private CmwapConnection(String url) {
        this.Url = url;
    }

    private void setScoket(SocketConnection c) {
        this.sc = c;
    }

    public boolean dataReceived() throws Exception {
        if (this.in == null) {
            return false;
        }
        if (this.in.available() != 0) {
            System.out.println("Available:" + this.in.available());
            return true;
        }
        System.out.println("Available:" + this.in.available());
        return false;
    }

    public static CmwapConnection open(String url) throws Exception {
        if (KxMIDlet.Debug) {
            System.out.println("CmwapConnection:" + url);
        }
        CmwapConnection cc = new CmwapConnection(url);
        String host = CmwapConnection.parseHost(url);
        SocketConnection c = (SocketConnection)Connector.open((String)("socket://" + host), (int)3, (boolean)true);
        cc.setScoket(c);
        return cc;
    }

    public void setRequestProperty(String key, String value) throws IOException {
        if (key.equals("Content-Length")) {
            this.ContentLength = value;
        } else if (key.equals("User-Agent")) {
            this.UserAgent = value;
        } else if (key.equals("Content-Type")) {
            this.ContentType = value;
        } else if (key.equals("X-online-Host")) {
            this.xonline = value;
        }
    }

    public void setRequestMethod(String method) throws IOException {
        this.strRequestMode = method;
    }

    public OutputStream openOutputStream() throws IOException {
        String host = CmwapConnection.parseHost(this.Url);
        String strIn = String.valueOf(this.strRequestMode) + " " + CmwapConnection.parseUrl(this.Url) + " HTTP/1.1\r\n";
        strIn = String.valueOf(strIn) + "Host: " + host + "\r\n";
        if (this.xonline != null) {
            strIn = String.valueOf(strIn) + "X-online-Host: " + this.xonline + "\r\n";
        }
        if (this.ContentLength != null) {
            strIn = String.valueOf(strIn) + "Content-Length: " + this.ContentLength + "\r\n";
        }
        if (this.ContentType != null) {
            strIn = String.valueOf(strIn) + "Content-Type: " + this.ContentType + "\r\n";
        }
        strIn = String.valueOf(strIn) + "User-Agent: " + this.UserAgent + "\r\n";
        if (this.bCompress) {
            strIn = String.valueOf(strIn) + "Accept-Encoding: gzip, deflate\r\n";
            this.bCompress = false;
        }
        strIn = String.valueOf(strIn) + "Connection: close\r\n";
        strIn = String.valueOf(strIn) + "accept:*/*\r\n\r\n";
        OutputStream out = this.sc.openOutputStream();
        this.in = this.sc.openInputStream();
        out.write(strIn.getBytes());
        return out;
    }

    public synchronized InputStream openInputStream() throws IOException {
        if (this.in != null) {
            return this.parseInputStream(this.in);
        }
        return null;
    }

    private InputStream parseInputStream(InputStream in) throws IOException {
        int ch;
        StringBuffer responseBuf = new StringBuffer();
        String header = null;
        String value = null;
        boolean bHeader = true;
        int crlf = 0;
        while ((ch = in.read()) != -1) {
            if (bHeader) {
                if (ch == 58) {
                    header = responseBuf.toString();
                    bHeader = false;
                    responseBuf = null;
                    responseBuf = new StringBuffer();
                    crlf = 0;
                    continue;
                }
                if (ch == 13) {
                    if (crlf != 17) continue;
                    ++crlf;
                    continue;
                }
                if (ch == 10) {
                    if (crlf == 18) {
                        crlf += 16;
                    }
                    if (crlf == 34) break;
                    this.response = responseBuf.toString();
                    responseBuf = new StringBuffer();
                    continue;
                }
                crlf = 0;
                responseBuf.append((char)ch);
                continue;
            }
            if (ch == 13) {
                if (crlf == 0) {
                    value = responseBuf.toString();
                    if (value != null) {
                        value = value.trim();
                    }
                    if (header != null) {
                        header = header.trim();
                    }
                    if (value != null && header != null && header.length() > 0) {
                        if (!this.headers.containsKey(header)) {
                            this.headers.put(header, value);
                        }
                        responseBuf = new StringBuffer();
                    }
                }
                ++crlf;
                continue;
            }
            if (ch == 10) {
                crlf += 16;
                bHeader = true;
                continue;
            }
            crlf = 0;
            responseBuf.append((char)ch);
        }
        String str = this.getHeaderField("Transfer-Encoding");
        if (str != null && str.compareTo("chunked") == 0) {
            return new CmwapInputStream(in, 1);
        }
        return in;
    }

    public synchronized void close() throws IOException {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.in = null;
        if (this.sc == null) {
            return;
        }
        try {
            this.sc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sc = null;
    }

    private static String parseHost(String url) {
        if (url.indexOf("http://") == -1) {
            return null;
        }
        String strUrl = url.substring(7, url.indexOf(47, 7));
        if (strUrl.indexOf(":") > 0) {
            return strUrl;
        }
        return String.valueOf(strUrl) + ":80";
    }

    private static String parseUrl(String url) {
        if (url.indexOf("http://") == -1) {
            return null;
        }
        return url.substring(url.indexOf(47, 7));
    }

    public int getResponseCode() throws IOException {
        if (this.response != null && this.response.length() > 0) {
            if (this.response.startsWith("HTTP")) {
                int nPos = this.response.indexOf(" ");
                if (nPos > 0) {
                    int nPos1 = this.response.indexOf(" ", nPos + 1);
                    if (nPos1 > 0) {
                        String str = this.response.substring(nPos, nPos1);
                        System.out.println("response:" + str);
                        try {
                            str = str.trim();
                            int n = Integer.parseInt(str);
                            return n;
                        }
                        catch (Exception e) {
                            return 0;
                        }
                    }
                    return 0;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    public long getLength() {
        if (!this.headers.contains("Content-Length")) {
            return -1L;
        }
        String str = (String)this.headers.get("Content-Length");
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public String getHeaderField(String head) {
        if (this.headers.containsKey(head)) {
            return (String)this.headers.get(head);
        }
        return null;
    }

    public String getHeaderFieldKey(int n) throws IOException {
        return null;
    }

    public String getURL() {
        return null;
    }

    public String getProtocol() {
        return null;
    }

    public String getHost() {
        return null;
    }

    public String getFile() {
        return null;
    }

    public String getRef() {
        return null;
    }

    public String getQuery() {
        return null;
    }

    public int getPort() {
        return 0;
    }

    public String getRequestMethod() {
        return null;
    }

    public String getRequestProperty(String arg0) {
        return null;
    }

    public String getResponseMessage() throws IOException {
        return null;
    }

    public long getExpiration() throws IOException {
        return 0L;
    }

    public long getDate() throws IOException {
        return 0L;
    }

    public long getLastModified() throws IOException {
        return 0L;
    }

    public String getHeaderField(int arg0) throws IOException {
        return null;
    }

    public int getHeaderFieldInt(String arg0, int arg1) throws IOException {
        return 0;
    }

    public long getHeaderFieldDate(String arg0, long arg1) throws IOException {
        return 0L;
    }

    public String getType() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public DataInputStream openDataInputStream() throws IOException {
        return null;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return null;
    }
}

