/*
 * Decompiled with CFR 0.152.
 */
package com.sina.parser.xml;

import com.sina.parser.xml.XMLDataBlock;
import com.sina.parser.xml.XMLDataListener;
import com.sina.parser.xml.XMLEventListener;
import com.sina.parser.xml.XMLParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class XMLEngine
implements XMLEventListener {
    private XMLParser parser = new XMLParser(this);
    public XMLDataListener listener = null;
    private XMLDataBlock currentBlock;
    private boolean ended;

    public void tagStarted(String name, Hashtable attributes) {
        this.currentBlock = new XMLDataBlock(name, this.currentBlock, attributes);
    }

    public boolean tagEnded(String name) {
        if (this.currentBlock == null) {
            return true;
        }
        XMLDataBlock parent = this.currentBlock.getParent();
        if (parent == null) {
            this.ended = true;
            return this.listener.blockArrived(this.currentBlock);
        }
        parent.addChild(this.currentBlock);
        this.currentBlock = parent;
        return true;
    }

    public void plaintextEncountered(String text) {
        if (this.currentBlock != null) {
            if (text.startsWith("![cdata[") || text.startsWith("![CDATA[")) {
                int index = text.indexOf("]]");
                String tmp = "";
                if (index > 8) {
                    tmp = text.substring(8, index);
                }
                this.currentBlock.addText(tmp.trim());
            } else if (text.startsWith("br") || text.startsWith("BR")) {
                this.currentBlock.addText("\n");
            } else {
                this.currentBlock.addText(text);
            }
        }
    }

    public boolean receiveHttpResponse(byte[] data, XMLDataListener listener1) throws IOException {
        block6: {
            String result;
            this.listener = listener1;
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            InputStreamReader inSource = new InputStreamReader((InputStream)is, "UTF-8");
            this.parser.inputReader = inSource;
            this.parser.inputReaderIndex = 0;
            int rs = 0;
            this.currentBlock = null;
            do {
                if ((result = this.parser.handlePlainText()) == null) continue;
                rs = this.parser.handleTag();
            } while (result != null && rs >= 0);
            if (rs != -10) break block6;
            return false;
        }
        try {
            if (!this.ended) {
                while (this.currentBlock != null && this.currentBlock.parent != null) {
                    this.currentBlock = this.currentBlock.parent;
                }
                return this.listener.blockArrived(this.currentBlock);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

