/*
 * Decompiled with CFR 0.152.
 */
package com.sina.ui;

import com.sina.ui.ControlItem;
import com.sina.ui.InputBox;
import com.sina.ui.InputListener;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import javax.microedition.lcdui.Graphics;

public class TextFieldItem
extends ControlItem
implements InputListener {
    public String[] title;
    public String[] text;
    public String content;
    public int maxSize;
    public int constraints;
    public int inputwidth;
    public int titleHeight;
    public int inputHeight;
    private int preferedHeight;
    private String bt;

    public TextFieldItem(String bt, String nr, int max, int cons) {
        this.width = G.W - 10;
        this.inputwidth = this.width - 14;
        this.bt = bt;
        this.title = Tools.stringFormatArray(bt, this.width, G.SHOW_FONT);
        this.maxSize = max;
        this.constraints = cons;
        if (nr != null && nr.length() > 0) {
            this.setText(nr);
        }
        this.update();
    }

    public void setWidth(int w) {
        this.width = w;
        this.inputwidth = this.width - 14;
        this.title = Tools.stringFormatArray(this.bt, this.width, G.SHOW_FONT);
        if (this.content != null && this.content.length() > 0) {
            this.setText(this.content);
        }
        this.update();
    }

    public void update() {
        this.titleHeight = this.title.length * G.SYS_FONTLINE_HEIGHT + 4;
        int h = 0;
        h = this.text != null && this.text.length > 0 ? this.text.length * G.SYS_FONTLINE_HEIGHT + 6 : G.SYS_FONTLINE_HEIGHT + 6;
        if (h > this.preferedHeight) {
            this.inputHeight = h;
        }
        this.height = this.titleHeight + this.inputHeight + 6;
    }

    public void setInputHeight(int height) {
        this.preferedHeight = height;
        this.inputHeight = height;
        this.height = this.titleHeight + this.inputHeight + 4;
    }

    public void paint(Graphics g, int clipx, int clipy) {
        int offy = this.painty;
        g.setColor(G.ContentColor);
        int i = 0;
        while (i < this.title.length) {
            g.drawString(this.title[i], this.paintx, offy + i * G.SYS_FONTLINE_HEIGHT, 20);
            ++i;
        }
        offy += this.titleHeight + 2;
        if (this.focus) {
            g.setColor(0x434343);
            g.fillRoundRect(this.paintx, offy, this.width, this.inputHeight, 10, 10);
            g.setColor(0xEAEAEA);
            g.fillRoundRect(this.paintx + 2, offy + 2, this.width - 4, this.inputHeight - 4, 10, 10);
        } else {
            g.setColor(0xABABAB);
            g.fillRoundRect(this.paintx, offy, this.width, this.inputHeight, 10, 10);
            g.setColor(0xEAEAEA);
            g.fillRoundRect(this.paintx + 2, offy + 2, this.width - 4, this.inputHeight - 4, 10, 10);
        }
        offy += 3;
        if (this.text != null) {
            g.setColor(G.TxtFeildTxtColor);
            i = 0;
            while (i < this.text.length) {
                if (this.constraints == 65536) {
                    g.drawString("******", this.paintx + 3, offy, 20);
                } else {
                    g.drawString(this.text[i], this.paintx + 3, offy, 20);
                }
                offy += G.SYS_FONTLINE_HEIGHT;
                ++i;
            }
        }
    }

    public void doEntry() {
        new InputBox(this);
    }

    public void setText(String text1, int id) {
        this.setText(text1);
    }

    public void setText(String text1) {
        if (text1 != null) {
            this.content = text1;
            this.text = text1.trim().length() == 0 ? null : Tools.stringFormatArray(text1, this.inputwidth, G.SHOW_FONT);
        } else {
            this.text = null;
        }
        this.update();
    }

    public String getText() {
        block3: {
            try {
                if (this.content != null) break block3;
                return "";
            }
            catch (Exception e) {
                return "";
            }
        }
        return this.content;
    }
}

