/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.data;

import com.sina.http.HttpEngine;
import com.sina.parser.xml.XMLDataBlock;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.data.AbstractBowenList;
import com.sina.weibo.data.Bowen;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class AtListModel
extends AbstractBowenList {
    private int currentID;
    public boolean loadHead = true;
    public boolean loading;
    public int loadHeadIndex;
    public boolean loadList;
    public int pageId = 1;
    public int pagesize = 20;
    public int count = 20;

    public AtListModel(ClientManager cm) {
        super(cm);
    }

    public void getBowenList(int pageid) {
        StringBuffer send = new StringBuffer();
        send.append("picsize=176&act=0&sid=");
        send.append(this.cm.currentAccount.sessionID);
        send.append("&gsid=");
        send.append(this.cm.currentAccount.gsid);
        send.append("&page=");
        send.append(pageid);
        send.append("&pagesize=");
        send.append(this.pagesize);
        this.cm.httpEngine.HttpConnect(1, 0, String.valueOf(G.serverPath) + "msg.php?" + send.toString(), null, this, HttpEngine.HIGH);
        this.loadList = true;
        this.loadHead = false;
        this.loadHeadIndex = 0;
        this.cm.setWait(true);
    }

    public boolean blockArrived(XMLDataBlock data) {
        if (this.currentID == 1) {
            return this.parseBowenList(data);
        }
        if (this.currentID == 3) {
            this.parseAddBowen(data);
        } else if (this.currentID == 4) {
            this.parseAddPinglun(data);
        } else if (this.currentID == 5) {
            this.parseAddZhuanfa(data);
        }
        return true;
    }

    private void parseAddBowen(XMLDataBlock data) {
        try {
            if (!data.getTagName().equals("rss")) {
                this.cm.showAlert("\u53d1\u9001\u5931\u8d25");
                this.cm.setWait(false);
                return;
            }
            Vector childvc = data.getChildBlocks();
            boolean err = false;
            if (childvc != null) {
                int i = 0;
                while (i < childvc.size()) {
                    XMLDataBlock itemdata = (XMLDataBlock)childvc.elementAt(i);
                    if (itemdata.getTagName().equals("sid")) {
                        this.cm.currentAccount.sessionID = itemdata.getText();
                    } else if (itemdata.getTagName().equals("result")) {
                        if ("0".equals(itemdata.getText())) {
                            err = true;
                        }
                    } else if (itemdata.getTagName().equals("errno")) {
                        err = true;
                    } else if (!itemdata.getTagName().equals("errmsg")) {
                        itemdata.getTagName().equals("url");
                    }
                    itemdata.close();
                    ++i;
                }
            }
            data.close();
            if (!err) {
                this.cm.showAlert("\u53d1\u9001\u6210\u529f");
                this.cm.back(true);
            } else {
                this.cm.showAlert("\u53d1\u9001\u5931\u8d25\uff01");
            }
            this.cm.setWait(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean parseBowenList(XMLDataBlock data) {
        block39: {
            if (data.getTagName().equals("rss")) break block39;
            return false;
        }
        try {
            this.bowenvc.removeAllElements();
            Vector childvc = data.getChildBlocks();
            if (childvc != null) {
                int i = 0;
                while (i < childvc.size()) {
                    XMLDataBlock itemdata = (XMLDataBlock)childvc.elementAt(i);
                    if (itemdata.getTagName().equals("mblog")) {
                        Bowen item = new Bowen(this.cm);
                        Vector child2 = itemdata.getChildBlocks();
                        if (child2 != null) {
                            int j = 0;
                            while (j < child2.size()) {
                                XMLDataBlock cc = (XMLDataBlock)child2.elementAt(j);
                                if (cc.getTagName().equals("nick")) {
                                    item.userName = cc.getText();
                                } else if (cc.getTagName().equals("uid")) {
                                    item.uid = cc.getText();
                                } else if (cc.getTagName().equals("mblogid")) {
                                    item.mblogid = cc.getText();
                                } else if (cc.getTagName().equals("content")) {
                                    String s = cc.getText();
                                    item.content = Tools.replace(s, "\\n", "\n");
                                } else if (cc.getTagName().equals("rtnum")) {
                                    try {
                                        item.zhuanfa = Integer.parseInt(cc.getText());
                                    }
                                    catch (RuntimeException e) {
                                        e.printStackTrace();
                                    }
                                } else if (cc.getTagName().equals("commentnum")) {
                                    try {
                                        item.pinglun = Integer.parseInt(cc.getText());
                                    }
                                    catch (RuntimeException e) {
                                        e.printStackTrace();
                                    }
                                } else if (cc.getTagName().equals("portrait")) {
                                    item.headURL = cc.getText();
                                } else if (cc.getTagName().equals("rtrootnick")) {
                                    item.rtrootnick = cc.getText();
                                } else if (cc.getTagName().equals("rtreason")) {
                                    item.rtreason = cc.getText();
                                } else if (cc.getTagName().equals("time")) {
                                    try {
                                        item.realtime = Long.parseLong(cc.getText());
                                        item.updateTime();
                                    }
                                    catch (RuntimeException runtimeException) {}
                                } else if (cc.getTagName().equals("pic")) {
                                    item.picURL = cc.getText();
                                }
                                cc.close();
                                ++j;
                            }
                        }
                        item.updateContent();
                        this.bowenvc.addElement(item);
                    } else if (itemdata.getTagName().equals("count")) {
                        this.count = Integer.parseInt(itemdata.getText());
                    } else if (itemdata.getTagName().equals("sid")) {
                        this.cm.currentAccount.sessionID = itemdata.getText();
                    }
                    ++i;
                }
            }
            data.close();
            this.loadHead = true;
            this.loadHeadIndex = 0;
            this.cm.updateView(9, 0);
            this.cm.setWait(false);
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void handleHttpError(int httpid, String errostr) {
        this.cm.showAlert("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff01\u8bf7\u5c1d\u8bd5\u5728\u5e10\u6237\u9875\u91cd\u7f6e\u7f51\u7edc\u3002");
        this.cm.setWait(false);
    }

    public boolean receiveHttpResponse(int httpid, int type, byte[] dis) {
        block7: {
            block8: {
                this.currentID = httpid;
                if (this.currentID != 2) break block7;
                if (this.loadHead) break block8;
                this.loading = false;
                return true;
            }
            try {
                Bowen b = (Bowen)this.bowenvc.elementAt(this.loadHeadIndex);
                b.headIcon = Image.createImage((byte[])dis, (int)0, (int)dis.length);
                int i = this.loadHeadIndex + 1;
                while (i < this.bowenvc.size()) {
                    Bowen b1 = (Bowen)this.bowenvc.elementAt(i);
                    if (b1.headURL.equals(b.headURL)) {
                        b1.headIcon = b.headIcon;
                    }
                    ++i;
                }
                this.cm.updateView(9, 1);
                ++this.loadHeadIndex;
                if (this.loadHeadIndex == this.bowenvc.size()) {
                    this.loadHead = false;
                    this.loadHeadIndex = 0;
                }
                this.loading = false;
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return this.cm.xmlEngine.receiveHttpResponse(dis, this);
    }

    public void loadNextHead() {
        this.loading = true;
        if (((Bowen)this.bowenvc.elementAt((int)this.loadHeadIndex)).headIcon == null) {
            this.cm.httpEngine.HttpConnect(2, 0, ((Bowen)this.bowenvc.elementAt((int)this.loadHeadIndex)).headURL, null, this, HttpEngine.HIGH);
        } else {
            ++this.loadHeadIndex;
            if (this.loadHeadIndex >= this.bowenvc.size()) {
                this.loadHead = false;
                this.loadHeadIndex = 0;
            }
            this.loading = false;
        }
    }
}

