/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.data;

import com.sina.http.HttpEngine;
import com.sina.http.HttpListener;
import com.sina.weibo.ClientManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class Bowen
implements HttpListener {
    public String userName;
    public String time;
    public String content;
    public Image headIcon;
    public Image pic;
    public String picURL;
    public int zhuanfa;
    public int pinglun;
    public String headURL;
    public long realtime;
    private ClientManager cm;
    public String uid;
    public String mblogid;
    private int picRMSID = -1;
    public String rtrootnick;
    public String rtreason = "";

    public Bowen(ClientManager cm) {
        this.cm = cm;
    }

    public void updateTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(this.realtime * 1000L));
        StringBuffer stringbuffer = new StringBuffer();
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(new Date(System.currentTimeMillis()));
        if (calendar.get(1) == calendar1.get(1) && calendar.get(2) == calendar1.get(2) && calendar.get(5) == calendar1.get(5)) {
            String hour = String.valueOf(calendar.get(11));
            if (hour.length() < 2) {
                stringbuffer.append("0");
            }
            stringbuffer.append(hour);
            stringbuffer.append(":");
            String min = String.valueOf(calendar.get(12));
            if (min.length() < 2) {
                stringbuffer.append("0");
            }
            stringbuffer.append(min);
        } else {
            String month = String.valueOf(calendar.get(2) + 1);
            stringbuffer.append(month);
            stringbuffer.append("\u6708");
            String day = String.valueOf(calendar.get(5));
            stringbuffer.append(day);
            stringbuffer.append("\u65e5");
        }
        this.time = stringbuffer.toString();
    }

    public void getPic() {
        if (this.picRMSID >= 0) {
            this.loadPic();
            if (this.pic != null) {
                return;
            }
        }
        this.cm.httpEngine.HttpConnect(0, 0, this.picURL, null, this, HttpEngine.HIGH);
        this.cm.superLoad = "\u6b63\u5728\u4e0b\u8f7d\u56fe\u7247";
        this.cm.setWait(true);
    }

    private void loadPic() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"PIC", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.closeRecordStore();
                return;
            }
            ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(recordStore.getRecord(this.picRMSID));
            DataInputStream datainputstream = new DataInputStream(bytearrayinputstream);
            int len = datainputstream.readInt();
            if (len > 0) {
                byte[] headIconByte = new byte[len];
                int i = 0;
                while (i < len) {
                    headIconByte[i] = datainputstream.readByte();
                    ++i;
                }
                try {
                    this.pic = Image.createImage((byte[])headIconByte, (int)0, (int)headIconByte.length);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                datainputstream.close();
                datainputstream = null;
            }
            this.cm.updateView(4, 0);
            recordStore.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleHttpError(int httpid, String errostr) {
        this.cm.showAlert("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff01\u8bf7\u5c1d\u8bd5\u5728\u5e10\u6237\u9875\u91cd\u7f6e\u7f51\u7edc\u3002");
        this.cm.setWait(false);
    }

    public boolean receiveHttpResponse(int httpid, int type, byte[] dis) {
        try {
            this.pic = Image.createImage((byte[])dis, (int)0, (int)dis.length);
            this.picRMSID = this.addPic(dis);
        }
        catch (RuntimeException e) {
            return false;
        }
        this.cm.setWait(false);
        this.cm.superLoad = null;
        this.cm.updateView(4, 0);
        return true;
    }

    private int addPic(byte[] data) {
        int index = -1;
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
        try {
            if (data != null) {
                dataoutputstream.writeInt(data.length);
                int j = 0;
                while (j < data.length) {
                    dataoutputstream.writeByte(data[j]);
                    ++j;
                }
            } else {
                dataoutputstream.writeInt(0);
            }
        }
        catch (IOException j) {
            // empty catch block
        }
        byte[] abyte0 = bytearrayoutputstream.toByteArray();
        try {
            bytearrayoutputstream.close();
            bytearrayoutputstream = null;
            RecordStore recordStore = RecordStore.openRecordStore((String)"PIC", (boolean)true);
            index = recordStore.addRecord(abyte0, 0, abyte0.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return index;
    }

    public void updateContent() {
        if (this.rtreason != null && !"".equals(this.rtreason)) {
            this.content = "\n\u8f6c\u53d1\u4e86 @" + this.rtrootnick + " \u7684\u5fae\u535a:" + this.content;
        }
    }
}

