/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.view;

import com.sina.ui.BackItem;
import com.sina.ui.ListItem;
import com.sina.ui.ListListener;
import com.sina.ui.ListRollContainer;
import com.sina.ui.WeiboListItem;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.data.Account;
import com.sina.weibo.data.SearchAccountListModel;
import com.sina.weibo.view.AbstractView;
import javax.microedition.lcdui.Graphics;

public class SearchUserListView
extends AbstractView
implements ListListener {
    private SearchAccountListModel blm;

    public SearchUserListView(ClientManager cm, SearchAccountListModel blm) {
        super(cm);
        this.viewID = 20;
        this.blm = blm;
        this.init();
    }

    public void keyPressed(int keyCode) {
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 7: {
                super.keyPressed(keyCode);
                break;
            }
            case 5: {
                this.blm.getAcount(0);
                this.blm.pageId = 1;
                break;
            }
            case 6: {
                this.cm.back(false);
                break;
            }
            case 1: {
                if (!this.list.movePre()) break;
                this.list.gotFocus((byte)1);
                break;
            }
            case 2: {
                if (!this.list.moveNext()) break;
                this.list.gotFocus((byte)0);
            }
        }
    }

    public void paint(Graphics g) {
        try {
            this.lrc.paint(g);
            Tools.drawMenuBar(g, "\u5237\u65b0", "\u8fd4\u56de", null);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
    }

    private void init() {
        BackItem li = new BackItem("\u641c\u7d22\uff1a" + this.blm.key);
        li.setPaintx(0);
        li.setPainty(0);
        li.setWidth(G.W);
        this.lrc.addItem(li);
        this.list = new ListRollContainer(G.W, G.H - li.getHeight() - G.MenuBarHeight);
        this.list.setPainty(li.getHeight());
        this.lrc.addItem(this.list);
        this.update(0);
    }

    public void update(int type) {
        if (this.blm.account.size() > 0) {
            if (type == 1) {
                int i = 0;
                while (i < this.blm.account.size()) {
                    WeiboListItem li = null;
                    li = this.blm.pageId > 1 ? (WeiboListItem)this.list.getItem(i + 1) : (WeiboListItem)this.list.getItem(i);
                    Account bowen = (Account)this.blm.account.elementAt(i);
                    li.setIcon(bowen.headIMG);
                    ++i;
                }
                this.render();
                return;
            }
            if (type == 0) {
                this.list.removeAll();
                if (this.blm != null && this.blm.account != null) {
                    if (this.blm.pageId > 1) {
                        ListItem li = new ListItem("\u4e0a\u4e00\u9875", -1, (ListListener)this, this.list, 1);
                        this.list.addItem(li);
                    }
                    this.blm.loadList = false;
                    int i = 0;
                    while (i < this.blm.account.size()) {
                        Account bowen = (Account)this.blm.account.elementAt(i);
                        WeiboListItem li = new WeiboListItem(bowen.nick, bowen.sex, bowen.fensishu, "", i, this, this.list);
                        li.setIcon(bowen.headIMG);
                        this.list.addItem(li);
                        ++i;
                    }
                    if (this.blm.count > this.blm.pagesize * this.blm.pageId) {
                        ListItem li = new ListItem("\u4e0b\u4e00\u9875", -2, (ListListener)this, this.list, 1);
                        this.list.addItem(li);
                    }
                }
            }
        }
        this.list.gotFocus((byte)1);
        this.render();
    }

    public void listitemPressed(int id) {
        if (id >= 0) {
            this.cm.changeStageWithObject(this.viewID, 13, this.blm.account.elementAt(id), false);
        } else if (id == -1) {
            if (this.blm.pageId > 1) {
                this.blm.getAcount(--this.blm.pageId);
            }
        } else if (id == -2) {
            this.blm.getAcount(++this.blm.pageId);
        } else if (id == -99) {
            this.blm.getAcount(0);
        }
    }

    public void tick(long time) {
        if (this.blm.loadHead && !this.blm.loading && this.blm.account.size() > 0) {
            this.blm.loadNextHead();
        }
    }
}

