/*
 * Decompiled with CFR 0.152.
 */
package com.bpi.encryption;

public class GenerationLibrary {
    public static final boolean DEBUG = false;
    public static final int TOTAL_VALUE_BASE32 = 32;
    public static final int TOTAL_INT_BIT = 32;
    public static final int TOTAL_BPC = 5;
    public static final int TOTAL_CODE = 13;
    public static final int TOTAL_CODE_WITH_CHECKBITS = 15;
    public static final int MAX_RANGE = 1000000000;
    public static final int TOTAL_NUMBER_DIGIT = 10;
    public static final int TOTAL_DIGIT = 9;
    public static final int[] DIGIT_TABLE = new int[]{10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    public static final int UID = 0;
    public static final int SCORE = 1;
    public static final int MASK1 = -1431655766;
    public static final int MASK2 = 0x55555555;
    public static final int SINGLE_BIT_MARK = 1;
    public static final int[][] UID_TABLE;
    public static final int[][] SOURCE_TABLE;
    public static long seed1;
    public static long seed2;
    public static int seed3;
    public static char[] BASE32;
    public static String BASE32_STR;

    static {
        int[][] nArrayArray = new int[10][];
        int[] nArray = new int[10];
        nArray[0] = 5;
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 1;
        nArray[4] = 7;
        nArray[6] = 3;
        nArray[7] = 9;
        nArray[8] = 6;
        nArray[9] = 8;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[10];
        nArray2[0] = 2;
        nArray2[1] = 4;
        nArray2[2] = 1;
        nArray2[3] = 7;
        nArray2[5] = 3;
        nArray2[6] = 9;
        nArray2[7] = 6;
        nArray2[8] = 8;
        nArray2[9] = 5;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[10];
        nArray3[0] = 4;
        nArray3[1] = 1;
        nArray3[2] = 7;
        nArray3[4] = 3;
        nArray3[5] = 9;
        nArray3[6] = 6;
        nArray3[7] = 8;
        nArray3[8] = 5;
        nArray3[9] = 2;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[10];
        nArray4[0] = 1;
        nArray4[1] = 7;
        nArray4[3] = 3;
        nArray4[4] = 9;
        nArray4[5] = 6;
        nArray4[6] = 8;
        nArray4[7] = 5;
        nArray4[8] = 2;
        nArray4[9] = 4;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[10];
        nArray5[0] = 7;
        nArray5[2] = 3;
        nArray5[3] = 9;
        nArray5[4] = 6;
        nArray5[5] = 8;
        nArray5[6] = 5;
        nArray5[7] = 2;
        nArray5[8] = 4;
        nArray5[9] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[10];
        nArray6[1] = 3;
        nArray6[2] = 9;
        nArray6[3] = 6;
        nArray6[4] = 8;
        nArray6[5] = 5;
        nArray6[6] = 2;
        nArray6[7] = 4;
        nArray6[8] = 1;
        nArray6[9] = 7;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[10];
        nArray7[0] = 3;
        nArray7[1] = 9;
        nArray7[2] = 6;
        nArray7[3] = 8;
        nArray7[4] = 5;
        nArray7[5] = 2;
        nArray7[6] = 4;
        nArray7[7] = 1;
        nArray7[8] = 7;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[10];
        nArray8[0] = 9;
        nArray8[1] = 6;
        nArray8[2] = 8;
        nArray8[3] = 5;
        nArray8[4] = 2;
        nArray8[5] = 4;
        nArray8[6] = 1;
        nArray8[7] = 7;
        nArray8[9] = 3;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[10];
        nArray9[0] = 6;
        nArray9[1] = 8;
        nArray9[2] = 5;
        nArray9[3] = 2;
        nArray9[4] = 4;
        nArray9[5] = 1;
        nArray9[6] = 7;
        nArray9[8] = 3;
        nArray9[9] = 9;
        nArrayArray[8] = nArray9;
        int[] nArray10 = new int[10];
        nArray10[0] = 8;
        nArray10[1] = 5;
        nArray10[2] = 2;
        nArray10[3] = 4;
        nArray10[4] = 1;
        nArray10[5] = 7;
        nArray10[7] = 3;
        nArray10[8] = 9;
        nArray10[9] = 6;
        nArrayArray[9] = nArray10;
        UID_TABLE = nArrayArray;
        int[][] nArrayArray2 = new int[10][];
        int[] nArray11 = new int[10];
        nArray11[0] = 7;
        nArray11[1] = 4;
        nArray11[2] = 5;
        nArray11[3] = 2;
        nArray11[4] = 3;
        nArray11[5] = 6;
        nArray11[6] = 1;
        nArray11[7] = 8;
        nArray11[8] = 9;
        nArrayArray2[0] = nArray11;
        int[] nArray12 = new int[10];
        nArray12[0] = 4;
        nArray12[1] = 5;
        nArray12[2] = 2;
        nArray12[3] = 3;
        nArray12[4] = 6;
        nArray12[5] = 1;
        nArray12[6] = 8;
        nArray12[7] = 9;
        nArray12[9] = 7;
        nArrayArray2[1] = nArray12;
        int[] nArray13 = new int[10];
        nArray13[0] = 5;
        nArray13[1] = 2;
        nArray13[2] = 3;
        nArray13[3] = 6;
        nArray13[4] = 1;
        nArray13[5] = 8;
        nArray13[6] = 9;
        nArray13[8] = 7;
        nArray13[9] = 4;
        nArrayArray2[2] = nArray13;
        int[] nArray14 = new int[10];
        nArray14[0] = 2;
        nArray14[1] = 3;
        nArray14[2] = 6;
        nArray14[3] = 1;
        nArray14[4] = 8;
        nArray14[5] = 9;
        nArray14[7] = 7;
        nArray14[8] = 4;
        nArray14[9] = 5;
        nArrayArray2[3] = nArray14;
        int[] nArray15 = new int[10];
        nArray15[0] = 3;
        nArray15[1] = 6;
        nArray15[2] = 1;
        nArray15[3] = 8;
        nArray15[4] = 9;
        nArray15[6] = 7;
        nArray15[7] = 4;
        nArray15[8] = 5;
        nArray15[9] = 2;
        nArrayArray2[4] = nArray15;
        int[] nArray16 = new int[10];
        nArray16[0] = 6;
        nArray16[1] = 1;
        nArray16[2] = 8;
        nArray16[3] = 9;
        nArray16[5] = 7;
        nArray16[6] = 4;
        nArray16[7] = 5;
        nArray16[8] = 2;
        nArray16[9] = 3;
        nArrayArray2[5] = nArray16;
        int[] nArray17 = new int[10];
        nArray17[0] = 1;
        nArray17[1] = 8;
        nArray17[2] = 9;
        nArray17[4] = 7;
        nArray17[5] = 4;
        nArray17[6] = 5;
        nArray17[7] = 2;
        nArray17[8] = 3;
        nArray17[9] = 6;
        nArrayArray2[6] = nArray17;
        int[] nArray18 = new int[10];
        nArray18[0] = 8;
        nArray18[1] = 9;
        nArray18[3] = 7;
        nArray18[4] = 4;
        nArray18[5] = 5;
        nArray18[6] = 2;
        nArray18[7] = 3;
        nArray18[8] = 6;
        nArray18[9] = 1;
        nArrayArray2[7] = nArray18;
        int[] nArray19 = new int[10];
        nArray19[0] = 9;
        nArray19[2] = 7;
        nArray19[3] = 4;
        nArray19[4] = 5;
        nArray19[5] = 2;
        nArray19[6] = 3;
        nArray19[7] = 6;
        nArray19[8] = 1;
        nArray19[9] = 8;
        nArrayArray2[8] = nArray19;
        int[] nArray20 = new int[10];
        nArray20[1] = 7;
        nArray20[2] = 4;
        nArray20[3] = 5;
        nArray20[4] = 2;
        nArray20[5] = 3;
        nArray20[6] = 6;
        nArray20[7] = 1;
        nArray20[8] = 8;
        nArray20[9] = 9;
        nArrayArray2[9] = nArray20;
        SOURCE_TABLE = nArrayArray2;
        seed1 = 1010002406L;
        seed2 = 501L;
        seed3 = 23;
        BASE32 = new char[]{'4', 'H', 'J', 'K', '9', 'R', 'S', '8', 'X', 'U', '6', 'E', '7', 'D', 'G', 'W', '2', 'N', 'A', '3', 'Z', 'B', 'C', 'L', 'F', 'P', 'V', '5', 'Y', 'T', 'Q', 'M'};
        int i2 = 0;
        while (i2 < BASE32.length) {
            int index = (int)((seed1 -= seed2 * (long)i2) % (long)BASE32.length);
            char tmp = BASE32[index];
            GenerationLibrary.BASE32[index] = BASE32[i2];
            GenerationLibrary.BASE32[i2] = tmp;
            BASE32_STR = new String(BASE32);
            ++i2;
        }
    }

    public static int[] decryption(String code) {
        int[] result = new int[]{-1, -1};
        try {
            if (code.length() == 13) {
                result = GenerationLibrary.base32DecodingData32(code, BASE32_STR);
                int uid = result[0] & 0xAAAAAAAA | result[1] & 0x55555555;
                int score = result[0] & 0x55555555 | result[1] & 0xAAAAAAAA;
                result[0] = GenerationLibrary.decodeNumber(uid, UID_TABLE);
                result[1] = GenerationLibrary.decodeNumber(score, SOURCE_TABLE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String encryption(int uid, int score) {
        String result = null;
        uid = GenerationLibrary.encodeNumber(uid, UID_TABLE);
        score = GenerationLibrary.encodeNumber(score, SOURCE_TABLE);
        int part1 = uid & 0xAAAAAAAA | score & 0x55555555;
        int part2 = uid & 0x55555555 | score & 0xAAAAAAAA;
        int[] data32 = new int[]{part1, part2};
        try {
            result = GenerationLibrary.base32Encoding(data32, BASE32_STR);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return result;
    }

    public static int encodeNumber(int raw, int[][] table) {
        int result = 0;
        if (raw >= 0 && raw < 1000000000) {
            int i2 = 8;
            while (i2 >= 0) {
                int ref10_1 = DIGIT_TABLE[i2];
                int ref10_2 = ref10_1 / 10;
                int tmp = raw % ref10_1;
                int oneDigit = tmp / ref10_2;
                int encryptOneDigit = table[i2][oneDigit];
                result += encryptOneDigit * ref10_2;
                --i2;
            }
        }
        return result;
    }

    public static int decodeNumber(int encoded, int[][] table) {
        int result = 0;
        if (encoded >= 0 && encoded < 1000000000) {
            int i2 = 8;
            while (i2 >= 0) {
                int ref10_1 = DIGIT_TABLE[i2];
                int ref10_2 = ref10_1 / 10;
                int tmp = encoded % ref10_1;
                int oneDigit = tmp / ref10_2;
                int decryptOneDigit = 0;
                int j2 = 0;
                while (j2 < 10) {
                    if (table[i2][j2] == oneDigit) {
                        decryptOneDigit = j2;
                    }
                    ++j2;
                }
                result += decryptOneDigit * ref10_2;
                --i2;
            }
        }
        return result;
    }

    public static String base32Encoding(int[] data32, String base32_reftable) {
        StringBuffer sb = new StringBuffer();
        int remainBit = 5;
        int bits = 0;
        int thebit = 0;
        try {
            int i2 = 0;
            while (i2 < data32.length) {
                int j2 = 31;
                while (j2 >= 0) {
                    if (remainBit == 0) {
                        sb.append(base32_reftable.charAt(bits));
                        bits = 0;
                        remainBit = 5;
                    }
                    thebit = data32[i2] & 1 << j2;
                    bits |= (thebit >>= j2) << --remainBit;
                    --j2;
                }
                ++i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        sb.append(BASE32[bits]);
        return sb.toString();
    }

    public static int[] base32DecodingData32(String code, String base32_reftable) {
        StringBuffer sb = new StringBuffer();
        int remainBit = 32;
        int bits = 0;
        int thebit = 0;
        int totalInt = code.length() * 5 / 32;
        int currentInt = 0;
        char[] charCode = code.toCharArray();
        int[] data32 = new int[totalInt];
        int i2 = 0;
        while (i2 < charCode.length) {
            bits = base32_reftable.indexOf(charCode[i2]);
            if (remainBit > 5) {
                data32[currentInt] = data32[currentInt] | bits << (remainBit -= 5);
            } else {
                int ref;
                int j2 = 0;
                while (remainBit > 0) {
                    ref = 5 - j2 - 1;
                    thebit = bits & 1 << ref;
                    data32[currentInt] = data32[currentInt] | (thebit >>= ref) << remainBit - 1;
                    --remainBit;
                    ++j2;
                }
                if (++currentInt < totalInt) {
                    remainBit = 32;
                    while (j2 < 5) {
                        ref = 5 - j2 - 1;
                        thebit = bits & 1 << ref;
                        data32[currentInt] = data32[currentInt] | (thebit >>= ref) << --remainBit;
                        ++j2;
                    }
                }
            }
            ++i2;
        }
        sb.append(BASE32[bits]);
        return data32;
    }
}

