/*
 * Decompiled with CFR 0.152.
 */
package my_java.security;

import java.util.Random;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class SecureRandom
extends Random {
    private static SecureRandom rand = new SecureRandom();
    private byte[] seed;
    private long counter = 1L;
    private SHA1Digest digest = new SHA1Digest();
    private byte[] state = new byte[this.digest.getDigestSize()];
    private byte[] intBytes = new byte[4];
    private byte[] longBytes = new byte[8];

    public SecureRandom() {
        super(0L);
        this.setSeed(System.currentTimeMillis());
    }

    public SecureRandom(byte[] byArray) {
        super(0L);
        this.setSeed(byArray);
    }

    public static SecureRandom getInstance(String string) {
        return new SecureRandom();
    }

    public static SecureRandom getInstance(String string, String string2) {
        return new SecureRandom();
    }

    public static byte[] getSeed(int n2) {
        byte[] byArray = new byte[n2];
        rand.setSeed(System.currentTimeMillis());
        rand.nextBytes(byArray);
        return byArray;
    }

    public byte[] generateSeed(int n2) {
        byte[] byArray = new byte[n2];
        this.nextBytes(byArray);
        return byArray;
    }

    public void setSeed(byte[] byArray) {
        this.digest.update(byArray, 0, byArray.length);
    }

    public void nextBytes(byte[] byArray) {
        int n2 = 0;
        this.digest.doFinal(this.state, 0);
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            if (n2 == this.state.length) {
                byte[] byArray2 = this.longToBytes(this.counter++);
                this.digest.update(byArray2, 0, byArray2.length);
                this.digest.update(this.state, 0, this.state.length);
                this.digest.doFinal(this.state, 0);
                n2 = 0;
            }
            byArray[i2] = this.state[n2++];
        }
        byte[] byArray3 = this.longToBytes(this.counter++);
        this.digest.update(byArray3, 0, byArray3.length);
        this.digest.update(this.state, 0, this.state.length);
    }

    public void setSeed(long l2) {
        if (l2 != 0L) {
            this.setSeed(this.longToBytes(l2));
        }
    }

    public int nextInt() {
        this.nextBytes(this.intBytes);
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            n2 = (n2 << 8) + (this.intBytes[i2] & 0xFF);
        }
        return n2;
    }

    protected final int next(int n2) {
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n3];
        this.nextBytes(byArray);
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = (n4 << 8) + (byArray[i2] & 0xFF);
        }
        return n4 & (1 << n2) - 1;
    }

    private byte[] longToBytes(long l2) {
        for (int i2 = 0; i2 != 8; ++i2) {
            this.longBytes[i2] = (byte)l2;
            l2 >>>= 8;
        }
        return this.longBytes;
    }
}

