/*
 * Decompiled with CFR 0.152.
 */
package customitem;

import customitem.TextInput;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;

public class Table
extends CustomItem
implements ItemCommandListener {
    private static final Command CMD_EDIT = new Command("Edit", 8, 1);
    private Display display;
    private int rows = 5;
    private int cols = 3;
    private int dx = 50;
    private int dy = 20;
    private static final int UPPER = 0;
    private static final int IN = 1;
    private static final int LOWER = 2;
    private int location = 0;
    private int currentX = 0;
    private int currentY = 0;
    private String[][] data = new String[this.rows][this.cols];
    boolean horz;
    boolean vert;

    public Table(String string, Display display) {
        super(string);
        this.display = display;
        this.setDefaultCommand(CMD_EDIT);
        this.setItemCommandListener(this);
        int n = this.getInteractionModes();
        this.horz = (n & 1) != 0;
        this.vert = (n & 2) != 0;
    }

    protected int getMinContentHeight() {
        return this.rows * this.dy + 1;
    }

    protected int getMinContentWidth() {
        return this.cols * this.dx + 1;
    }

    protected int getPrefContentHeight(int n) {
        return this.rows * this.dy + 1;
    }

    protected int getPrefContentWidth(int n) {
        return this.cols * this.dx + 1;
    }

    protected void paint(Graphics graphics, int n, int n2) {
        int n3;
        for (n3 = 0; n3 <= this.rows; ++n3) {
            graphics.drawLine(0, n3 * this.dy, this.cols * this.dx, n3 * this.dy);
        }
        for (n3 = 0; n3 <= this.cols; ++n3) {
            graphics.drawLine(n3 * this.dx, 0, n3 * this.dx, this.rows * this.dy);
        }
        n3 = graphics.getColor();
        graphics.setColor(0xD0D0D0);
        graphics.fillRect(this.currentX * this.dx + 1, this.currentY * this.dy + 1, this.dx - 1, this.dy - 1);
        graphics.setColor(n3);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (this.data[i][j] == null) continue;
                int n4 = graphics.getClipX();
                int n5 = graphics.getClipY();
                int n6 = graphics.getClipWidth();
                int n7 = graphics.getClipHeight();
                graphics.setClip(j * this.dx + 1, i * this.dy, this.dx - 1, this.dy - 1);
                graphics.drawString(this.data[i][j], j * this.dx + 2, (i + 1) * this.dy - 2, 36);
                graphics.setClip(n4, n5, n6, n7);
            }
        }
    }

    protected boolean traverse(int n, int n2, int n3, int[] nArray) {
        if (this.horz && this.vert) {
            switch (n) {
                case 6: {
                    if (this.location == 0) {
                        this.location = 1;
                        break;
                    }
                    if (this.currentY < this.rows - 1) {
                        ++this.currentY;
                        this.repaint(this.currentX * this.dx, (this.currentY - 1) * this.dy, this.dx, this.dy);
                        this.repaint(this.currentX * this.dx, this.currentY * this.dy, this.dx, this.dy);
                        break;
                    }
                    this.location = 2;
                    return false;
                }
                case 1: {
                    if (this.location == 2) {
                        this.location = 1;
                        break;
                    }
                    if (this.currentY > 0) {
                        --this.currentY;
                        this.repaint(this.currentX * this.dx, (this.currentY + 1) * this.dy, this.dx, this.dy);
                        this.repaint(this.currentX * this.dx, this.currentY * this.dy, this.dx, this.dy);
                        break;
                    }
                    this.location = 0;
                    return false;
                }
                case 2: {
                    if (this.currentX <= 0) break;
                    --this.currentX;
                    this.repaint((this.currentX + 1) * this.dx, this.currentY * this.dy, this.dx, this.dy);
                    this.repaint(this.currentX * this.dx, this.currentY * this.dy, this.dx, this.dy);
                    break;
                }
                case 5: {
                    if (this.currentX >= this.cols - 1) break;
                    ++this.currentX;
                    this.repaint((this.currentX - 1) * this.dx, this.currentY * this.dy, this.dx, this.dy);
                    this.repaint(this.currentX * this.dx, this.currentY * this.dy, this.dx, this.dy);
                }
            }
        } else if (this.horz || this.vert) {
            switch (n) {
                case 1: 
                case 2: {
                    if (this.location == 2) {
                        this.location = 1;
                        break;
                    }
                    if (this.currentX > 0) {
                        --this.currentX;
                        this.repaint((this.currentX + 1) * this.dx, this.currentY * this.dy, this.dx, this.dy);
                        this.repaint(this.currentX * this.dx, this.currentY * this.dy, this.dx, this.dy);
                        break;
                    }
                    if (this.currentY > 0) {
                        --this.currentY;
                        this.repaint(this.currentX * this.dx, (this.currentY + 1) * this.dy, this.dx, this.dy);
                        this.currentX = this.cols - 1;
                        this.repaint(this.currentX * this.dx, this.currentY * this.dy, this.dx, this.dy);
                        break;
                    }
                    this.location = 0;
                    return false;
                }
                case 5: 
                case 6: {
                    if (this.location == 0) {
                        this.location = 1;
                        break;
                    }
                    if (this.currentX < this.cols - 1) {
                        ++this.currentX;
                        this.repaint((this.currentX - 1) * this.dx, this.currentY * this.dy, this.dx, this.dy);
                        this.repaint(this.currentX * this.dx, this.currentY * this.dy, this.dx, this.dy);
                        break;
                    }
                    if (this.currentY < this.rows - 1) {
                        ++this.currentY;
                        this.repaint(this.currentX * this.dx, (this.currentY - 1) * this.dy, this.dx, this.dy);
                        this.currentX = 0;
                        this.repaint(this.currentX * this.dx, this.currentY * this.dy, this.dx, this.dy);
                        break;
                    }
                    this.location = 2;
                    return false;
                }
            }
        }
        nArray[0] = this.currentX;
        nArray[1] = this.currentY;
        nArray[2] = this.dx;
        nArray[3] = this.dy;
        return true;
    }

    public void setText(String string) {
        this.data[this.currentY][this.currentX] = string;
        this.repaint(this.currentY * this.dx, this.currentX * this.dy, this.dx, this.dy);
    }

    public void commandAction(Command command, Item item) {
        if (command == CMD_EDIT) {
            TextInput textInput = new TextInput(this.data[this.currentY][this.currentX], this, this.display);
            this.display.setCurrent((Displayable)textInput);
        }
    }
}

