/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.blogger.controller;

import com.sonyericsson.blogger.controller.ApplicationListener;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionHandlerMap;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.invocation.InvocationAction;
import com.sonyericsson.webalbum.invocation.InvocationHandler;
import com.sonyericsson.webalbum.invocation.InvocationListener;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.util.CacheUtil;
import javax.microedition.content.Invocation;

public class MainController
implements InvocationListener,
ActionResponseListener {
    private ApplicationListener appListener;
    private InvocationHandler invocHandler;
    private ActionHandlerMap actionHandlerMap;

    public MainController(ApplicationListener appListener, InvocationHandler invocHandler, ActionHandlerMap actionHandlerMap) {
        this.appListener = appListener;
        this.invocHandler = invocHandler;
        this.actionHandlerMap = actionHandlerMap;
        invocHandler.setInvocationListener(this);
    }

    public void start() {
        Log.trace(this, "start");
        this.invocHandler.start();
    }

    public void stop() {
        Log.trace(this, "stop");
        this.invocHandler.stop();
        this.appListener.notifyDestroyed();
    }

    public void inactivityNotify() {
        Log.trace(this, "inactivityNotify");
        this.stop();
    }

    public void invocationRequestNotify(Invocation invocation) {
        Log.trace(this, "invocationRequestNotify");
        InvocationAction action = new InvocationAction(invocation);
        ActionHandler actionHandler = this.actionHandlerMap.getHandler(action.getAction());
        String baseDirUrl = action.getMainData().getUrl();
        if (actionHandler != null && baseDirUrl != null) {
            try {
                this.initCache(baseDirUrl);
                actionHandler.handleAction(action, this);
            }
            catch (Throwable t) {
                this.invocHandler.finishInvocation(invocation, 6);
            }
        } else {
            this.invocHandler.finishInvocation(invocation, 6);
        }
    }

    public void actionCompleteNotify(Action action) {
        Log.trace(this, "actionCompleteNotify");
        try {
            ActionData ad = action.getMainData();
            Attributes attr = ad.getAttributes();
            String r = attr.get("result");
            Log.trace(this, "actionCompleteNotify result: " + r);
        }
        catch (Exception e) {
            Log.logException(e);
        }
        this.invocHandler.finishInvocation(((InvocationAction)action).getInvocation(), 5);
    }

    public void actionProgressNotify(Action action) {
        Log.trace(this, "actionProgressNotify");
        this.invocHandler.reportInvocationProgress(((InvocationAction)action).getInvocation());
    }

    private void initCache(String baseDirUrl) {
        if (CacheUtil.getCacheDirUrl() == null) {
            if (!baseDirUrl.endsWith("/")) {
                baseDirUrl = String.valueOf(baseDirUrl) + "/";
            }
            CacheUtil.setCacheDirUrl(String.valueOf(baseDirUrl) + "cache/");
        }
    }
}

