/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.blogger.service.action;

import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.CapabilityCodec;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Capability;
import com.sonyericsson.webalbum.service.Result;

public class CapabilitiesActionHandler
implements ActionHandler {
    private static final String NS_CAPABILITY = "capability:";
    private static final String ATTR_ITEM_TYPE = "item:type";
    private static final int CONTENT_TITLE_MAX_LENGTH = 100;
    private static final int CONTENT_TEXT_MAX_LENGTH = 1000;
    private static final int COMMENT_TITLE_MAX_LENGTH = 100;
    private static final int COMMENT_TEXT_MAX_LENGTH = 1000;
    private static final int COMMENT_AUTHOR_MAX_LENGTH = 100;

    private void addCapability(Attributes attr, Capability capability) {
        String value = CapabilityCodec.encodeCapability(capability);
        attr.set(NS_CAPABILITY + capability.getName(), value);
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        Log.trace(this, "handleAction");
        int result = 0;
        ActionData actionData = action.getMainData();
        Attributes inAttr = actionData.getAttributes();
        Attributes outAttr = new Attributes();
        String type = inAttr.get(ATTR_ITEM_TYPE);
        outAttr.set(ATTR_ITEM_TYPE, type);
        Capability capability = null;
        if (type == null) {
            result = 4;
        } else if (type.equals("item")) {
            capability = new Capability(ATTR_ITEM_TYPE, true);
            capability.addAllowedValue("content");
            capability.addAllowedValue("comment");
            this.addCapability(outAttr, capability);
        } else if (type.equals("content")) {
            this.addCapability(outAttr, new Capability("content:title", false, 100));
            this.addCapability(outAttr, new Capability("content:text", false, 1000));
        } else if (type.equals("comment")) {
            this.addCapability(outAttr, new Capability("comment:title", true, 100));
            this.addCapability(outAttr, new Capability("comment:text", true, 1000));
            this.addCapability(outAttr, new Capability("comment:author-name", true, 100));
        } else {
            result = 3;
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

