/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.blogger.service.action;

import com.sonyericsson.blogger.service.action.ActionUtil;
import com.sonyericsson.blogger.service.http.FeedRequest;
import com.sonyericsson.blogger.service.xml.FeedParser;
import com.sonyericsson.blogger.settings.Settings;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import java.util.Vector;

public class ListActionHandler
implements ActionHandler {
    private static final String ATTR_LIST_START_ENTRY = "list:start-entry";
    private static final String ATTR_LIST_END_ENTRY = "list:end-entry";
    private static final String NO_BLOG_ID = "0";

    public void handleAction(Action action, ActionResponseListener responseListener) {
        int endIndex;
        int startIndex;
        Log.trace(this, "handleAction");
        int result = 0;
        ActionData actionData = action.getMainData();
        Attributes inAttr = actionData.getAttributes();
        Vector entries = new Vector();
        if (!NO_BLOG_ID.equals(Settings.getBlogId())) {
            String type = inAttr.get("item:type");
            Log.trace(this, "Get " + type + " from feeds");
            FeedParser parser = FeedParser.createParser(type);
            FeedRequest request = FeedRequest.createFeedRequest(type, parser);
            try {
                ActionUtil.doHttpRequest(request, 1);
            }
            catch (ServiceException e) {
                Log.logException(e);
            }
            entries = parser.getEntries();
        }
        Log.trace(this, "got entries from parser");
        try {
            startIndex = Integer.parseInt(inAttr.get(ATTR_LIST_START_ENTRY));
            endIndex = Integer.parseInt(inAttr.get(ATTR_LIST_END_ENTRY));
        }
        catch (NumberFormatException e) {
            startIndex = 0;
            endIndex = Integer.MAX_VALUE;
        }
        Attributes outAttr = new Attributes();
        int i = startIndex;
        while (i < entries.size() && i < endIndex) {
            try {
                Entry entry = (Entry)entries.elementAt(i);
                ActionData childData = action.addChildData();
                Attributes partOutAttr = EntryCodec.encodeEntry(entry);
                childData.setAttributes(partOutAttr);
            }
            catch (Exception e) {
                Log.logException(e);
            }
            ++i;
        }
        outAttr.set("list:entry-count", String.valueOf(entries.size()));
        outAttr.set(ATTR_LIST_START_ENTRY, String.valueOf(startIndex));
        outAttr.set(ATTR_LIST_END_ENTRY, String.valueOf(startIndex + entries.size()));
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

