/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.blogger.service.http;

import com.sonyericsson.blogger.service.http.UrlFactory;
import com.sonyericsson.blogger.service.xml.UploadResponseParser;
import com.sonyericsson.blogger.util.Base64;
import com.sonyericsson.blogger.util.PhoneUtils;
import com.sonyericsson.webalbum.http.HttpRequest;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.util.IOUtil;
import com.sonyericsson.webalbum.util.MimeUtil;
import com.sonyericsson.webalbum.xml.XmlEncoder;
import com.sonyericsson.webalbum.xml.XmlException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class UploadContentRequest
extends HttpRequest {
    private static final String SHARED_SECRET = "fc1707420ee3c2395bd0";
    private UploadResponseParser parser;
    private Content content;

    public UploadContentRequest(Content content, UploadResponseParser parser) {
        super("POST", UrlFactory.createUploadContentUrl(), UploadContentRequest.createHeaders(content));
        this.parser = parser;
        this.content = content;
        Log.trace(this, "UploadContentRequest");
    }

    private static Hashtable createHeaders(Content content) {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        LengthCalculatorStream lcs = new LengthCalculatorStream();
        try {
            UploadContentRequest.writeBody(lcs, content);
            Log.trace("com.sonyericsson.blogger.service.http.UploadContentRequest createHeaders Length of post: " + lcs.length);
            headers.put("Content-Length", Integer.toString(lcs.length));
            headers.put("Authentication", UploadContentRequest.getPassword());
            headers.put("Content-Type", "application/atom+xml");
            headers.put("Accept", "application/atom+xml");
            headers.put("Proxy-Connection", "Keep-Alive");
            headers.put("User-Agent", "SonyEricsson");
            headers.put("Host", "wap.sonyericsson.com");
            headers.put("Accept-Language", "sv");
            headers.put("Accept-Charset", "*");
            headers.put("Accept", "*/*");
        }
        catch (IOException e) {
            Log.logException(e);
        }
        return headers;
    }

    private static String getPassword() {
        String password = null;
        String temp = String.valueOf(PhoneUtils.getDeviceId()) + SHARED_SECRET;
        byte[] bytes = temp.getBytes();
        byte[] hash = new byte[20];
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(bytes, 0, bytes.length);
            md.digest(hash, 0, hash.length);
            StringBuffer sb = new StringBuffer(hash.length * 2);
            int i = 0;
            while (i < hash.length) {
                int b = hash[i];
                if (b < 0) {
                    b += 256;
                }
                if (b < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(b));
                ++i;
            }
            password = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            Log.logException(e);
        }
        catch (DigestException e) {
            Log.logException(e);
        }
        return password;
    }

    private static void writeImageData(OutputStream os, String file) throws IOException {
        Log.trace("com.sonyericsson.blogger.service.http.UploadContentRequest writeImageData");
        FileConnection fc = null;
        InputStream is = null;
        try {
            int nrReadBytes;
            fc = (FileConnection)Connector.open((String)file);
            is = fc.openInputStream();
            byte[] bytes = new byte[3072];
            while ((nrReadBytes = is.read(bytes)) > 0) {
                String base64data = Base64.encode(bytes, 0, nrReadBytes);
                byte[] towrite = base64data.getBytes("UTF-8");
                os.write(towrite);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeInputStream(is);
            IOUtil.closeConnection((Connection)fc);
            throw throwable;
        }
        IOUtil.closeInputStream(is);
        IOUtil.closeConnection((Connection)fc);
    }

    private static String getCurrentZuluTime() {
        Calendar rightNow = Calendar.getInstance();
        StringBuffer time = new StringBuffer();
        TimeZone timezone = TimeZone.getDefault();
        time.append(rightNow.get(1));
        time.append("-");
        if (rightNow.get(2) < 10) {
            time.append("0");
        }
        time.append(rightNow.get(2));
        time.append("-");
        if (rightNow.get(5) < 10) {
            time.append("0");
        }
        time.append(rightNow.get(5));
        time.append("T");
        if (rightNow.get(11) < 10) {
            time.append("0");
        }
        time.append(rightNow.get(11));
        time.append(":");
        if (rightNow.get(12) < 10) {
            time.append("0");
        }
        time.append(rightNow.get(12));
        time.append(":");
        if (rightNow.get(13) < 10) {
            time.append("0");
        }
        time.append(rightNow.get(13));
        if (timezone.getRawOffset() <= 0) {
            time.append("-");
        } else {
            time.append("+");
        }
        if (timezone.getRawOffset() / 3600 < 10) {
            time.append("0");
        }
        time.append(timezone.getRawOffset() / 3600);
        time.append(":");
        if (timezone.getRawOffset() % 3600 < 10) {
            time.append("0");
        }
        time.append(timezone.getRawOffset() % 3600);
        return time.toString();
    }

    private static void writeBody(OutputStream os, Content theContent) throws IOException {
        Log.trace("com.sonyericsson.blogger.service.http.UploadContentRequest internal writeBody");
        XmlEncoder enc = new XmlEncoder(os);
        String title = theContent.getTitle();
        String contenttext = theContent.getText();
        String currentTime = UploadContentRequest.getCurrentZuluTime();
        Resource resource = theContent.getResource("content");
        String filename = resource.getLocalUrl();
        String mimeType = MimeUtil.getContentTypeFromUrl(filename);
        Log.trace("blogger writebody mimetype: " + mimeType);
        enc.addXmlElement();
        enc.startElement("atom:entry", "xmlns:atom=\"http://www.w3.org/2005/Atom\" xml:lang=\"en-US\"");
        enc.addElement("atom:updated", null, currentTime);
        enc.addElement("atom:category", "scheme=\"http://www.google.com/type\" term=\"blog.post\"");
        enc.addElement("atom:title", "type=\"text\"", title);
        enc.startElement("atom:content", "type=\"xhtml\"");
        enc.startElement("div", "xmlns=\"http://www.w3.org/1999/xhtml\"");
        enc.flush();
        os.write("<object width=\"200\" type=\"".getBytes("UTF-8"));
        os.write(mimeType.getBytes("UTF-8"));
        os.write("\" data=\"data:".getBytes("UTF-8"));
        os.write(mimeType.getBytes("UTF-8"));
        os.write(";base64,".getBytes("UTF-8"));
        UploadContentRequest.writeImageData(os, filename);
        os.write("\" />".getBytes("UTF-8"));
        enc.addElement("span", null, contenttext);
        enc.endElement();
        enc.endElement();
        enc.startElement("atom:author");
        enc.addElement("atom:name", null, "me");
        enc.endElement();
        enc.addElement("device", "xmlns=\"http://sonyericsson.com/moblog/ns#\" name=\"Dummy\"");
        enc.endElement();
        enc.flush();
    }

    public void writeBody(OutputStream os) throws IOException {
        Log.trace(this, "writeBody");
        UploadContentRequest.writeBody(os, this.content);
    }

    public void readResponseBody(InputStream is) throws IOException {
        Log.trace(this, "readResponseBody responseCode: " + this.getResponseCode());
        if (this.getResponseCode() == 200) {
            try {
                this.parser.parse(is);
            }
            catch (XmlException e) {
                Log.logException(e);
            }
        } else {
            Log.trace(this, "readResponseBody: " + is.toString());
        }
    }

    private static class LengthCalculatorStream
    extends OutputStream {
        private int length = 0;

        private LengthCalculatorStream() {
        }

        public void write(byte[] data) throws IOException {
            this.length += data.length;
        }

        public void write(int arg0) throws IOException {
        }
    }
}

