/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.blogger.util;

import com.sonyericsson.blogger.util.Base64;
import com.sonyericsson.webalbum.log.Log;
import java.security.MessageDigest;

public abstract class PhoneUtils {
    private static final String PROPERTY_PLATFORM = "microedition.platform";
    private static final String PROPERTY_IMSI = "com.sonyericsson.sim.imsi";
    private static final String PROPERTY_IMEI = "com.sonyericsson.imei";
    private static final String PLATFORM_VENDOR_PREFIX = "SonyEricsson";
    private static final int IMSI_PACKED_LENGTH = 9;
    private static final int IMSI_UNPACKED_LENGTH = 15;

    private static String getUnpackedIMSI() {
        String IMSI = System.getProperty(PROPERTY_IMSI);
        if (IMSI == null) {
            throw new RuntimeException("Could not read IMSI");
        }
        return IMSI;
    }

    private static byte[] getPackedIMSI() {
        String unpackedIMSI = PhoneUtils.getUnpackedIMSI();
        int unpackedLength = unpackedIMSI.length();
        byte packedLength = (byte)(unpackedLength / 2 + 1);
        byte[] packedIMSI = new byte[9];
        packedIMSI[0] = packedLength;
        packedIMSI[1] = 9;
        int i = 0;
        while (i < 15) {
            char c;
            int nibble = 15;
            if (i < unpackedLength && Character.isDigit(c = unpackedIMSI.charAt(i))) {
                nibble = (byte)(c - 48);
            }
            int packedPos = (i + 3) / 2;
            int shift = i % 2 == 0 ? 4 : 0;
            int n = packedPos;
            packedIMSI[n] = (byte)(packedIMSI[n] + (nibble << shift));
            ++i;
        }
        return packedIMSI;
    }

    private static String getUnpackedIMEI() {
        String IMEI = System.getProperty(PROPERTY_IMEI);
        if (IMEI == null) {
            throw new RuntimeException("Could not read IMEI");
        }
        return IMEI;
    }

    private static byte[] getPackedIMEI() {
        String unpackedIMEI = PhoneUtils.getUnpackedIMEI();
        byte[] packedIMEI = new byte[15];
        int j = 0;
        int i = 5;
        while (i < unpackedIMEI.length() - 3) {
            char c = unpackedIMEI.charAt(i);
            if (Character.isDigit(c)) {
                packedIMEI[j++] = (byte)(c - 48);
            }
            ++i;
        }
        return packedIMEI;
    }

    public static String getIMEI() {
        byte[] packedIMEI = PhoneUtils.getPackedIMEI();
        char[] IMEI = new char[packedIMEI.length];
        int i = 0;
        while (i < IMEI.length) {
            IMEI[i] = (char)(packedIMEI[i] + 48);
            ++i;
        }
        return new String(IMEI);
    }

    public static String getDeviceId() {
        String deviceId = "";
        byte[] imei = PhoneUtils.getPackedIMEI();
        byte[] imsi = PhoneUtils.getPackedIMSI();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(imei, 0, imei.length);
            md.update(imsi, 0, imsi.length);
            byte[] hash = new byte[20];
            md.digest(hash, 0, hash.length);
            deviceId = Base64.encode(hash, 0, hash.length);
            deviceId = deviceId.replace('/', '-');
            deviceId = deviceId.replace('+', '_');
        }
        catch (Exception e) {
            Log.logException(e);
        }
        return deviceId;
    }

    public static String getPhoneModel() {
        String platform = System.getProperty(PROPERTY_PLATFORM);
        String phoneModel = null;
        if (platform != null && platform.startsWith(PLATFORM_VENDOR_PREFIX)) {
            int versionSeparator = platform.indexOf(47);
            phoneModel = versionSeparator > PLATFORM_VENDOR_PREFIX.length() ? platform.substring(PLATFORM_VENDOR_PREFIX.length(), versionSeparator) : platform.substring(PLATFORM_VENDOR_PREFIX.length());
        }
        return phoneModel;
    }
}

