/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.webalbum.service.transfer;

import com.sonyericsson.webalbum.job.Job;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.TransferItem;
import com.sonyericsson.webalbum.service.transfer.TransferJobListener;
import com.sonyericsson.webalbum.service.transfer.TransferRequest;

public abstract class TransferJob
extends Job {
    private TransferItem[] items;
    private int currentItemIndex;
    private TransferJobListener listener;
    protected boolean cancelled;
    protected TransferRequest currentRequest;

    protected TransferJob(int id, TransferItem[] items) {
        super(id);
        this.items = items;
    }

    public final void setTransferJobListener(TransferJobListener listener) {
        this.listener = listener;
    }

    protected final void reportProgress() {
        this.listener.transferProgressNotify(this.id, this.items);
    }

    protected final TransferItem getCurrentItem() {
        return this.items[this.currentItemIndex];
    }

    public final void cancel() {
        Log.trace("TransferJob#cancel");
        this.cancelled = true;
        if (this.currentRequest != null) {
            this.currentRequest.cancel();
        }
    }

    public void requestProgressNotify() {
        this.getCurrentItem().setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
        this.reportProgress();
    }

    public final void run() {
        int result = 0;
        Log.trace("TransferJob#run: starting");
        this.currentItemIndex = 0;
        while (this.currentItemIndex < this.items.length) {
            if (this.items[this.currentItemIndex].getState() == 1) {
                if (this.cancelled) {
                    this.items[this.currentItemIndex].setState(3);
                } else if (result != 0) {
                    this.items[this.currentItemIndex].setState(4);
                } else {
                    Log.trace("TransferJob#run: transferring item " + this.currentItemIndex);
                    try {
                        result = this.transferCurrentItem();
                    }
                    catch (Throwable t) {
                        this.items[this.currentItemIndex].setState(4);
                        Log.warning("TransferJob#run: Unhandled error " + t.getClass().getName());
                    }
                }
            }
            ++this.currentItemIndex;
        }
        Log.trace("TransferJob#run: done");
        this.listener.transferCompleteNotify(this.id, this.items, result);
    }

    protected abstract int transferCurrentItem();
}

