/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.blogger.midlet;

import com.sonyericsson.blogger.controller.ApplicationListener;
import com.sonyericsson.blogger.controller.MainController;
import com.sonyericsson.blogger.service.action.CancelActionHandler;
import com.sonyericsson.blogger.service.action.CapabilitiesActionHandler;
import com.sonyericsson.blogger.service.action.DownloadActionHandler;
import com.sonyericsson.blogger.service.action.InfoActionHandler;
import com.sonyericsson.blogger.service.action.ListActionHandler;
import com.sonyericsson.blogger.service.action.UploadActionHandler;
import com.sonyericsson.blogger.service.config.Config;
import com.sonyericsson.blogger.settings.Settings;
import com.sonyericsson.webalbum.action.ActionHandlerMap;
import com.sonyericsson.webalbum.codec.AlbumCodec;
import com.sonyericsson.webalbum.codec.CommentCodec;
import com.sonyericsson.webalbum.codec.ContentCodec;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.codec.ImageResourceCodec;
import com.sonyericsson.webalbum.codec.ResourceCodec;
import com.sonyericsson.webalbum.invocation.InvocationHandler;
import com.sonyericsson.webalbum.job.JobManager;
import com.sonyericsson.webalbum.log.ConsoleLogWriter;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.log.LogWriter;
import javax.microedition.content.ContentHandlerException;
import javax.microedition.content.ContentHandlerServer;
import javax.microedition.content.Registry;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class BloggerMIDlet
extends MIDlet
implements ApplicationListener {
    private static final int DEFAULT_TIMEOUT = 60000;
    private boolean started = false;
    private MainController controller;
    private JobManager jobManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public BloggerMIDlet() {
        Settings.init(Registry.getRegistry((String)this.getClass().getName()));
    }

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        Log.trace(this, "destroyApp");
        this.controller.stop();
    }

    protected void pauseApp() {
        Log.trace(this, "pauseApp");
    }

    protected void startApp() throws MIDletStateChangeException {
        Log.trace(this, "startApp");
        if (!this.started) {
            this.started = true;
            Log.setWriter(this.getLogWriter());
            Log.setLevel(this.getLogLevel());
            String property = this.getAppProperty("photo-upload-size");
            if (property != null) {
                Config.setPhotoUploadSize(Integer.parseInt(property));
            }
            this.registerCodecs();
            this.jobManager = new JobManager();
            InvocationHandler invocHandler = new InvocationHandler(this.getServer(), this.getTimeout());
            this.controller = new MainController(this, invocHandler, this.getActionHandlerMap());
            this.controller.start();
        }
    }

    private int getLogLevel() {
        int logLevel = 0;
        String property = this.getAppProperty("log-level");
        if (property != null) {
            if (property.equalsIgnoreCase("none")) {
                logLevel = 0;
            } else if (property.equalsIgnoreCase("error")) {
                logLevel = 1;
            } else if (property.equalsIgnoreCase("warning")) {
                logLevel = 2;
            } else if (property.equalsIgnoreCase("info")) {
                logLevel = 3;
            } else if (property.equalsIgnoreCase("trace")) {
                logLevel = 4;
            }
        }
        return logLevel;
    }

    private int getTimeout() {
        int timeout = 60000;
        String property = this.getAppProperty("timeout");
        if (property != null) {
            try {
                timeout = Integer.parseInt(property);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return timeout;
    }

    private void registerCodecs() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sonyericsson.webalbum.model.ImageResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ResourceCodec.registerCodec(clazz, new ImageResourceCodec());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.sonyericsson.webalbum.model.Resource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ResourceCodec.registerCodec(clazz2, new ResourceCodec());
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("com.sonyericsson.webalbum.model.Album");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EntryCodec.registerCodec(clazz3, new AlbumCodec());
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("com.sonyericsson.webalbum.model.Content");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EntryCodec.registerCodec(clazz4, new ContentCodec());
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("com.sonyericsson.webalbum.model.Comment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EntryCodec.registerCodec(clazz5, new CommentCodec());
    }

    protected ActionHandlerMap getActionHandlerMap() {
        ActionHandlerMap map = new ActionHandlerMap();
        map.addHandler("info", new InfoActionHandler());
        map.addHandler("capabilities", new CapabilitiesActionHandler());
        map.addHandler("upload", new UploadActionHandler(this.jobManager));
        map.addHandler("cancel", new CancelActionHandler(this.jobManager));
        map.addHandler("list", new ListActionHandler());
        map.addHandler("download", new DownloadActionHandler(this.jobManager));
        return map;
    }

    protected ContentHandlerServer getServer() {
        ContentHandlerServer server = null;
        try {
            server = Registry.getServer((String)this.getClass().getName());
        }
        catch (ContentHandlerException e) {
            Log.logException((Exception)((Object)e));
        }
        return server;
    }

    protected LogWriter getLogWriter() {
        return new ConsoleLogWriter();
    }
}

