/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.blogger.service.action;

import com.sonyericsson.webalbum.http.HttpRequest;
import com.sonyericsson.webalbum.http.HttpUtil;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.ServiceException;
import java.io.IOException;

public abstract class ActionUtil {
    static final int PROTOCOL_VERSION_1_0 = 0;
    static final int PROTOCOL_VERSION_1_1 = 1;

    public static void doHttpRequest(HttpRequest request, int protocolVersion) throws ServiceException {
        Log.trace("com.sonyericsson.blogger.controller.ActionUtil doHttpRequest");
        int result = 0;
        try {
            HttpUtil.doRequest(request, protocolVersion);
            int responseCode = request.getResponseCode();
            Log.trace("com.sonyericsson.blogger.controller.ActionUtil doHttpRequest responseCode: " + responseCode);
            result = ActionUtil.resultFromHttpResponseCode(responseCode);
        }
        catch (IOException e) {
            Log.logException(e);
            result = 8;
        }
        Log.trace(null, "com.sonyericsson.blogger.controller.ActionUtil doHttpRequest result:" + result);
        if (result != 0) {
            throw new ServiceException(result);
        }
    }

    public static int resultFromHttpResponseCode(int responseCode) {
        int result = 0;
        switch (responseCode) {
            case 200: 
            case 201: {
                result = 0;
                break;
            }
            case 401: 
            case 403: {
                result = 5;
                break;
            }
            case 400: 
            case 404: {
                result = 2;
                break;
            }
            case 500: {
                result = 7;
                break;
            }
            default: {
                result = 12;
            }
        }
        return result;
    }
}

