/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.blogger.service.action;

import com.sonyericsson.blogger.service.action.UploadJob;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.job.JobManager;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.model.UploadItem;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.service.transfer.TransferJobResponseHandler;

public class UploadActionHandler
implements ActionHandler {
    private JobManager jobManager;

    public UploadActionHandler(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        Log.trace(this, "handleAction");
        ActionData mainData = action.getMainData();
        Attributes mainInAttr = mainData.getAttributes();
        try {
            int transferId = 0;
            int count = action.getChildDataCount();
            UploadItem[] items = new UploadItem[count];
            try {
                transferId = Integer.parseInt(mainInAttr.get("transfer:id"));
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException(2);
            }
            int i = 0;
            while (i < count) {
                Log.trace(this, "creating entry " + (i + 1) + " of " + count);
                ActionData childData = action.getChildData(i);
                Entry entry = EntryCodec.decodeEntry(childData.getAttributes());
                String localUrl = childData.getUrl();
                items[i] = new UploadItem(entry);
                if (entry instanceof Content && localUrl != null) {
                    Resource resource = new Resource("content");
                    resource.setLocalUrl(localUrl);
                    entry.addResource(resource);
                    items[i].setState(1);
                } else {
                    items[i].setState(4);
                }
                ++i;
            }
            UploadJob uj = new UploadJob(transferId, items, action.getMainData().getUrl());
            uj.setTransferJobListener(new TransferJobResponseHandler(action, responseListener));
            this.jobManager.addJob(uj);
        }
        catch (ServiceException se) {
            Log.trace(this, "Could not create upload job");
            Log.logException(se);
            int result = se.getResult();
            Attributes outAttr = new Attributes();
            outAttr.set("result", Result.toString(result), 0);
            mainData.setAttributes(outAttr);
            responseListener.actionCompleteNotify(action);
        }
    }
}

