/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.blogger.service.action;

import com.sonyericsson.blogger.service.action.ActionUtil;
import com.sonyericsson.blogger.service.http.UploadContentRequest;
import com.sonyericsson.blogger.service.xml.UploadResponseParser;
import com.sonyericsson.blogger.settings.Settings;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.model.UploadItem;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.service.transfer.TransferJob;
import com.sonyericsson.webalbum.util.IOUtil;
import com.sonyericsson.webalbum.util.MediaUtil;
import com.sonyericsson.webalbum.util.MimeUtil;
import java.io.IOException;
import javax.microedition.content.ContentHandlerException;
import javax.microedition.content.Invocation;
import javax.microedition.media.MediaException;

public class UploadJob
extends TransferJob {
    private static final String SECRET_FILECOPY_PREFIX = "tmpcpy23048973";
    private int nbrOfItemsLeftToUpload;
    private String workingDir = null;

    protected UploadJob(int id, UploadItem[] items, String workingDir) {
        super(id, items);
        this.nbrOfItemsLeftToUpload = items.length;
        this.workingDir = workingDir;
        Log.info(this, "Constructor, nbrOfItemsLeftToUpload= " + this.nbrOfItemsLeftToUpload);
    }

    protected int transferCurrentItem() {
        Log.trace(this, "transferCurrentItem, nbrOfItemsLeftToUpload: " + this.nbrOfItemsLeftToUpload);
        int result = 0;
        UploadItem item = (UploadItem)this.getCurrentItem();
        this.prepareItemForUpload(item);
        UploadResponseParser parser = new UploadResponseParser();
        item.setState(2);
        this.reportProgress();
        UploadContentRequest uploadRequest = new UploadContentRequest((Content)item.getEntry(), parser);
        try {
            ActionUtil.doHttpRequest(uploadRequest, 0);
        }
        catch (ServiceException e) {
            result = e.getResult();
            Log.trace(this, "doHttpRequest failed, result:" + Result.toString(result));
        }
        if (result == 0) {
            item.setState(5);
            if (--this.nbrOfItemsLeftToUpload < 1) {
                Log.trace(this, "Transfer done");
                Log.trace(this, "Blog title: " + parser.getBlogTitle());
                Log.trace(this, "Blog uri: " + parser.getBlogUri());
                Log.trace(this, "Claim uri: " + parser.getClaimUri());
                Log.trace(this, "Claim token: " + parser.getClaimToken());
                Log.trace(this, "Comment feed url: " + parser.getCommentFeedUrl());
                this.handlePostComplete(parser);
            } else {
                Log.trace(this, "More items to upload, nbrOfItemsLeftToUpload=" + this.nbrOfItemsLeftToUpload);
            }
        } else {
            item.setState(4);
        }
        this.reportProgress();
        Resource resource = item.getEntry().getResource("content");
        String filename = resource.getLocalUrl();
        Log.trace(this, "Finished uploading file " + filename);
        if (filename.indexOf(SECRET_FILECOPY_PREFIX) >= 0) {
            IOUtil.deleteFile(filename);
        }
        Log.trace(this, "transferCurrentItem returning " + Result.toString(result));
        return result;
    }

    private void prepareItemForUpload(UploadItem item) {
        block6: {
            Log.trace(this, "prepareItemForUpload");
            Entry entry = item.getEntry();
            Resource resource = entry.getResource("content");
            String localUrl = resource.getLocalUrl();
            if ("image/jpeg".equals(MimeUtil.getContentTypeFromUrl(localUrl))) {
                try {
                    String destUrl = String.valueOf(this.workingDir) + "/" + SECRET_FILECOPY_PREFIX + System.currentTimeMillis() + ".jpg";
                    Log.trace(this, "localUrl:" + localUrl + " destUrl:" + destUrl);
                    if (MediaUtil.resizeImage(localUrl, "image/jpeg", 800, destUrl)) {
                        Log.trace(this, "Resized picture to " + destUrl);
                        resource.setLocalUrl(destUrl);
                        break block6;
                    }
                    Log.trace(this, "No resizing of picture necessary");
                }
                catch (MediaException me) {
                    Log.logException((Exception)((Object)me));
                }
                catch (IOException ioe) {
                    Log.logException(ioe);
                }
            } else {
                Log.trace(this, "copyAndResizePicture non jpg");
            }
        }
    }

    private void handlePostComplete(UploadResponseParser parser) {
        Log.trace(this, "handlePostComplete");
        Settings.setBlogId(parser.getBlogId());
        Settings.setCommentFeedUrl(parser.getCommentFeedUrl());
        if (parser.getClaimUri() != null && parser.getClaimUri().length() > 0) {
            Log.trace(this, "handlePostComplete, invoking notification");
            String invocString = "blogger://finish?claimurl=" + parser.getClaimUri() + "&claimtoken=" + parser.getClaimToken() + "&blogaddress=" + parser.getBlogUri();
            try {
                Invocation invoc = new Invocation(invocString, null, "com.sonyericsson.bloggerutil.helper", false, "execute");
                Settings.getRegistry().invoke(invoc);
            }
            catch (ContentHandlerException che) {
                Log.warning(this, "HandlePostComplete caught a ContentHandlerException");
            }
            catch (IOException e) {
                Log.logException(e);
            }
        }
    }
}

