/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.blogger.service.http;

import com.sonyericsson.blogger.service.http.CommentFeedRequest;
import com.sonyericsson.blogger.service.http.MainFeedRequest;
import com.sonyericsson.blogger.service.xml.FeedParser;
import com.sonyericsson.webalbum.http.HttpRequest;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.xml.XmlException;
import java.io.IOException;
import java.io.InputStream;

public abstract class FeedRequest
extends HttpRequest {
    private FeedParser parser;

    public static FeedRequest createFeedRequest(String type, FeedParser parser) {
        if ("content".equals(type) || "album".equals(type)) {
            return new MainFeedRequest(parser);
        }
        if ("comment".equals(type)) {
            return new CommentFeedRequest(parser);
        }
        return null;
    }

    protected FeedRequest(String url, FeedParser feedparser) {
        super("GET", url);
        this.parser = feedparser;
        Log.trace(this, "FeedRequest url:" + url);
    }

    public void readResponseBody(InputStream is) throws IOException {
        Log.trace(this, "readResponseBody responseCode: " + this.getResponseCode());
        if (this.getResponseCode() == 200) {
            try {
                this.parser.parse(is);
            }
            catch (XmlException e) {
                Log.logException(e);
            }
        } else {
            Log.warning(this, "responseCode = " + this.getResponseCode());
        }
    }
}

