/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.blogger.service.xml;

import com.sonyericsson.blogger.service.xml.FeedParser;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Album;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.util.MimeUtil;
import java.util.Vector;
import org.xml.sax.Attributes;

public class AlbumFeedParser
extends FeedParser {
    private static final String DUMMY_ALBUM_ID = "0";
    private String blogTitle = "";
    private String albumThumbnailUrl = "";

    protected AlbumFeedParser() {
    }

    public String getBlogTitle() {
        if (this.blogTitle == null) {
            this.blogTitle = "";
        }
        return this.blogTitle;
    }

    public String getAlbumThumbnailUrl() {
        if (this.albumThumbnailUrl == null) {
            this.albumThumbnailUrl = "";
        }
        return this.albumThumbnailUrl;
    }

    protected void startElement(String element, Attributes attributes) {
        if (element.equals("media:thumbnail") && "".equals(this.albumThumbnailUrl)) {
            this.albumThumbnailUrl = attributes.getValue("url");
            Log.trace(this, "Found albumThumbnailUrl: " + this.getAlbumThumbnailUrl());
        }
    }

    protected void characters(String element, char[] ch, int start, int length) {
        if (this.isCurrentPath("/feed/title")) {
            this.blogTitle = new String(ch, start, length);
            Log.trace(this, "Found blog title: " + this.blogTitle);
        }
    }

    public Vector getEntries() {
        Vector<Album> entries = new Vector<Album>();
        Album album = new Album();
        album.setId(DUMMY_ALBUM_ID);
        album.setTitle(this.blogTitle);
        if (this.getAlbumThumbnailUrl().length() > 0) {
            Resource albumThumbnail = new Resource("cover-image", this.getAlbumThumbnailUrl(), MimeUtil.getContentTypeFromUrl(this.getAlbumThumbnailUrl()));
            album.addResource(albumThumbnail);
        }
        entries.addElement(album);
        return entries;
    }
}

