/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.blogger.service.xml;

import com.sonyericsson.blogger.service.xml.FeedParser;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Comment;
import java.util.Calendar;
import java.util.Vector;
import org.xml.sax.Attributes;

public class CommentFeedParser
extends FeedParser {
    private Vector commentList = new Vector();
    private Comment currentComment = null;
    private String commentId = "";
    private String author = "";
    private String title = "";
    private String text = "";
    private long timestamp = 0L;

    protected CommentFeedParser() {
    }

    protected void startElement(String element, Attributes attributes) {
        if (element.equals("entry")) {
            this.currentComment = new Comment();
            Log.trace(this, "Found new comment");
        }
    }

    protected void endElement(String element) {
        if (element.equals("entry") && this.currentComment != null) {
            this.currentComment.setId(this.commentId != null ? this.commentId : "");
            this.currentComment.setTitle(this.title != null ? this.title : "");
            this.currentComment.setText(this.text != null ? this.text : "");
            this.currentComment.setAuthorName(this.author != null ? this.author : "");
            this.currentComment.setTimestamp(this.timestamp);
            this.commentList.addElement(this.currentComment);
            Log.trace(this, "Created comment: title=" + this.title + " text=" + this.text + " commentId=" + this.commentId + " author=" + this.author);
        }
    }

    protected void characters(String element, char[] ch, int start, int length) {
        if (this.isCurrentPath("/feed/entry/author/name")) {
            this.author = new String(ch, start, length);
            Log.trace(this, "Found comment author: " + this.author);
        } else if (this.isCurrentPath("/feed/entry/title")) {
            this.title = new String(ch, start, length);
            Log.trace(this, "Found comment title: " + this.title);
        } else if (this.isCurrentPath("/feed/entry/content")) {
            this.text = new String(ch, start, length);
            Log.trace(this, "Found comment text: " + this.text);
        } else if (this.isCurrentPath("/feed/entry/id")) {
            Log.trace(this, "Found id");
            String idtag = new String(ch, start, length);
            this.commentId = idtag.substring(idtag.lastIndexOf(45) + 1);
            Log.trace(this, "Found commentId = " + this.commentId);
        } else if (this.isCurrentPath("/feed/entry/published")) {
            Log.trace(this, "Found published date");
            String isoTime = new String(ch, start, length);
            this.timestamp = this.decodeTimestamp(isoTime);
            Log.trace(this, "Found timestamp = " + this.timestamp);
        }
    }

    private long decodeTimestamp(String isoTime) {
        long timestamp = 0L;
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, Integer.parseInt(isoTime.substring(0, 4)));
            calendar.set(2, Integer.parseInt(isoTime.substring(5, 7)) - 1);
            calendar.set(5, Integer.parseInt(isoTime.substring(8, 10)));
            calendar.set(11, Integer.parseInt(isoTime.substring(11, 13)));
            calendar.set(12, Integer.parseInt(isoTime.substring(14, 16)));
            calendar.set(13, Integer.parseInt(isoTime.substring(17, 19)));
            calendar.set(14, 0);
            timestamp = calendar.getTime().getTime();
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return timestamp;
    }

    public Vector getEntries() {
        return this.commentList;
    }
}

