/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.blogger.service.xml;

import com.sonyericsson.blogger.service.xml.FeedParser;
import com.sonyericsson.blogger.service.xml.PostParser;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.util.MimeUtil;
import com.sonyericsson.webalbum.xml.XmlException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;
import org.xml.sax.Attributes;

public class ContentFeedParser
extends FeedParser {
    private Vector contentList = new Vector();
    private String postId = "";
    private Content currentContent = null;
    private String resourceUrl = "";
    private String thumbnailUrl = "";
    private String entryTitle = "";
    private String entryText = "";

    protected ContentFeedParser() {
    }

    protected void startElement(String element, Attributes attributes) {
        if (element.equals("entry")) {
            this.currentContent = new Content();
            Log.trace(this, "Found new content");
            this.postId = "";
            this.resourceUrl = "";
            this.thumbnailUrl = "";
            this.entryTitle = "";
            this.entryText = "";
        } else if (element.equals("media:thumbnail")) {
            this.thumbnailUrl = attributes.getValue("url");
            Log.trace(this, "Found thumbnail url: " + this.thumbnailUrl);
        }
    }

    protected void endElement(String element) {
        if (element.equals("entry") && this.currentContent != null && this.resourceUrl != null && this.resourceUrl.length() > 0) {
            Resource image = new Resource("content", this.resourceUrl, MimeUtil.getContentTypeFromUrl(this.resourceUrl));
            this.currentContent.addResource(image);
            if (this.thumbnailUrl != null && this.thumbnailUrl.length() > 0) {
                Resource thumbnail = new Resource("thumbnail", this.thumbnailUrl, MimeUtil.getContentTypeFromUrl(this.thumbnailUrl));
                this.currentContent.addResource(thumbnail);
            }
            this.currentContent.setTitle(this.entryTitle != null ? this.entryTitle : "");
            this.currentContent.setText(this.entryText != null ? this.entryText : "");
            this.currentContent.setId(this.postId != null ? this.postId : "");
            this.contentList.addElement(this.currentContent);
            Log.trace(this, "Created content: title=" + this.entryTitle + " resourceUrl=" + this.resourceUrl + " thumbnailUrl=" + this.thumbnailUrl + "postId= " + this.postId);
        }
    }

    protected void characters(String element, char[] ch, int start, int length) {
        if (this.isCurrentPath("/feed/entry/title") && this.currentContent != null) {
            this.entryTitle = new String(ch, start, length);
            Log.trace(this, "Found entry title: " + this.entryTitle);
        } else if (this.isCurrentPath("/feed/entry/content") && this.currentContent != null) {
            String contentString = new String(ch, start, length);
            Log.trace(this, "Found content: " + contentString);
            ByteArrayInputStream is = new ByteArrayInputStream(contentString.getBytes());
            PostParser parser = new PostParser();
            try {
                parser.parse(is);
                this.resourceUrl = parser.getContentUrl();
                this.entryText = parser.getContentText();
            }
            catch (IOException e) {
                Log.logException(e);
            }
            catch (XmlException e) {
                Log.trace(this, "content probably malformed");
            }
        } else if (this.isCurrentPath("/feed/entry/id") && this.currentContent != null) {
            Log.trace(this, "Found id");
            String idtag = new String(ch, start, length);
            if (idtag != null) {
                this.postId = idtag.substring(idtag.lastIndexOf(45) + 1, idtag.length());
            }
            Log.trace(this, "Found postId = " + this.postId);
        }
    }

    public Vector getEntries() {
        return this.contentList;
    }
}

