/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.blogger.settings;

import com.sonyericsson.webalbum.log.Log;
import javax.microedition.content.Registry;
import javax.microedition.rms.RecordStore;

public abstract class Settings {
    private static final String RECORDSTORE_NAME = "blogger-settings";
    private static Registry registry = null;

    public static synchronized void init(Registry registry) {
        Log.trace(null, "com.sonyericsson.blogger.settings.Settings Init");
        Settings.registry = registry;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RECORDSTORE_NAME, (boolean)true);
            if (rs.getNumRecords() < 1) {
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                Log.trace(null, "Initiated settings");
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            Log.logException(e);
        }
    }

    public static synchronized String getBlogId() {
        String blogId = "0";
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RECORDSTORE_NAME, (boolean)true);
            if (rs.getNumRecords() > 0) {
                byte[] data = rs.getRecord(1);
                blogId = new String(data);
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            Log.logException(e);
        }
        Log.trace(null, "com.sonyericsson.blogger.settings.Settings getBlogId: " + blogId);
        return blogId;
    }

    public static synchronized void setBlogId(String blogId) {
        Log.trace(null, "com.sonyericsson.blogger.settings.Settings setBlogId: " + blogId);
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RECORDSTORE_NAME, (boolean)true);
            rs.setRecord(1, blogId.getBytes(), 0, blogId.getBytes().length);
            rs.closeRecordStore();
        }
        catch (Exception e) {
            Log.logException(e);
        }
    }

    public static synchronized String getCommentFeedUrl() {
        String url = "0";
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RECORDSTORE_NAME, (boolean)true);
            if (rs.getNumRecords() > 0) {
                byte[] data = rs.getRecord(2);
                url = new String(data);
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            Log.logException(e);
        }
        Log.trace(null, "com.sonyericsson.blogger.settings.Settings getCommentFeedUrl: " + url);
        return url;
    }

    public static synchronized void setCommentFeedUrl(String url) {
        Log.trace(null, "com.sonyericsson.blogger.settings.Settings setCommentFeedUrl: " + url);
        try {
            RecordStore rs = RecordStore.openRecordStore((String)RECORDSTORE_NAME, (boolean)true);
            rs.setRecord(2, url.getBytes(), 0, url.getBytes().length);
            rs.closeRecordStore();
        }
        catch (Exception e) {
            Log.logException(e);
        }
    }

    public static Registry getRegistry() {
        return registry;
    }
}

