/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.webalbum.codec;

import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.AttributeCodec;
import com.sonyericsson.webalbum.codec.ResourceCodec;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.Resource;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class EntryCodec {
    public static final String ATTR_ITEM_TYPE = "item:type";
    public static final String ATTR_ID = ":id";
    public static final String ATTR_TIMESTAMP = ":timestamp";
    public static final String ATTR_WEBPAGE_URL = ":webpage-url";
    public static final String ATTR_RSS_URL = ":rss-url";
    private static final String NS_RESOURCE = "resource:";
    private static Hashtable entryCodecs = new Hashtable();
    private String itemType;

    protected EntryCodec(String itemType) {
        this.itemType = itemType;
    }

    private static EntryCodec getEntryCodec(Class entryClass) {
        return (EntryCodec)entryCodecs.get(entryClass);
    }

    private static EntryCodec getEntryCodec(String itemType) {
        Enumeration en = entryCodecs.elements();
        while (en.hasMoreElements()) {
            EntryCodec codec = (EntryCodec)en.nextElement();
            if (!codec.getItemType().equals(itemType)) continue;
            return codec;
        }
        return null;
    }

    public static void registerCodec(Class entryClass, EntryCodec entryCodec) {
        entryCodecs.put(entryClass, entryCodec);
    }

    public static final Entry decodeEntry(Attributes attributes) {
        Entry entry = null;
        String type = attributes.get(ATTR_ITEM_TYPE);
        EntryCodec codec = null;
        if (type != null) {
            codec = EntryCodec.getEntryCodec(type);
        }
        if (codec != null) {
            entry = codec.createEntry();
            codec.decodeEntry(attributes, entry);
        }
        return entry;
    }

    public static final Attributes encodeEntry(Entry entry) {
        Attributes attr = null;
        EntryCodec codec = EntryCodec.getEntryCodec(entry.getClass());
        if (codec != null) {
            attr = new Attributes();
            codec.encodeEntry(entry, attr);
        }
        return attr;
    }

    public final String getItemType() {
        return this.itemType;
    }

    public static final String getItemType(Entry entry) {
        return EntryCodec.getEntryCodec(entry.getClass()).getItemType();
    }

    protected abstract Entry createEntry();

    protected void decodeEntry(Attributes attributes, Entry entry) {
        String type = attributes.get(ATTR_ITEM_TYPE);
        Log.trace("EntryCodec.decodeEntry()");
        entry.setId(attributes.get(String.valueOf(type) + ATTR_ID));
        String timestamp = attributes.get(String.valueOf(this.itemType) + ATTR_TIMESTAMP);
        try {
            entry.setTimestamp(Long.parseLong(timestamp));
        }
        catch (Exception exception) {
            // empty catch block
        }
        entry.setWebPageUrl(AttributeCodec.decodeAttribute(attributes.get(String.valueOf(this.itemType) + ATTR_WEBPAGE_URL)));
        entry.setRssUrl(AttributeCodec.decodeAttribute(attributes.get(String.valueOf(this.itemType) + ATTR_RSS_URL)));
    }

    protected void encodeEntry(Entry entry, Attributes attributes) {
        Log.trace("EntryCodec.encodeEntry()");
        attributes.set(ATTR_ITEM_TYPE, this.itemType);
        attributes.set(String.valueOf(this.itemType) + ATTR_ID, entry.getId());
        attributes.set(String.valueOf(this.itemType) + ATTR_TIMESTAMP, String.valueOf(entry.getTimestamp()));
        attributes.set(String.valueOf(this.itemType) + ATTR_WEBPAGE_URL, AttributeCodec.encodeAttribute(entry.getWebPageUrl()));
        attributes.set(String.valueOf(this.itemType) + ATTR_RSS_URL, AttributeCodec.encodeAttribute(entry.getRssUrl()));
    }

    protected final void encodeResource(Entry entry, String name, Attributes attributes) {
        Resource resource = entry.getResource(name);
        if (resource != null) {
            String value = ResourceCodec.encodeResource(resource);
            attributes.set(NS_RESOURCE + name, value);
        }
    }
}

