/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.webalbum.codec;

import com.sonyericsson.webalbum.codec.AttributeCodec;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.util.StringMap;
import com.sonyericsson.webalbum.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class ResourceCodec {
    private static final String SEPARATOR = "&";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_URL = "url";
    private static final String VALUE_PREFIX = "url=";
    private static Hashtable resourceCodecs = new Hashtable();

    private static ResourceCodec getCodec(Class resourceClass) {
        return (ResourceCodec)resourceCodecs.get(resourceClass);
    }

    public static void registerCodec(Class resourceClass, ResourceCodec resourceCodec) {
        resourceCodecs.put(resourceClass, resourceCodec);
    }

    public static final String encodeResource(Resource resource) {
        ResourceCodec codec = ResourceCodec.getCodec(resource.getClass());
        String result = null;
        try {
            StringMap params = new StringMap();
            codec.encodeParams(resource, params);
            result = StringUtil.encodeKeyValueString(params, SEPARATOR, AttributeCodec.getStringCodec()).substring(VALUE_PREFIX.length());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    protected void encodeParams(Resource resource, StringMap params) {
        params.put(ATTRIBUTE_URL, resource.getUrl(), 0);
        params.put(ATTRIBUTE_TYPE, resource.getType(), 1);
    }
}

