/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.webalbum.http;

import com.sonyericsson.webalbum.log.Log;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.SocketConnection;

class HttpConnection_1_0
implements HttpConnection {
    private static final String POST = "POST";
    private static final int HTTP_NOT_READ = -1;
    private SocketConnection socket = null;
    private String protocol = "http://";
    private String server = "";
    private String port = ":80";
    private String path = "";
    private String requestMethod = "POST";
    private Hashtable requestHeader = new Hashtable();
    private int responseCode = -1;
    private String responseMessage = "";
    private Hashtable responseHeader = new Hashtable();
    private InputStream inputStream = null;
    private OutputStream outputStream = null;

    private HttpConnection_1_0(String url) throws IOException {
        if (!url.startsWith("http://")) {
            throw new IOException("Invalid url scheme, could not open connection.");
        }
        int firstSlash = url.indexOf("/", this.protocol.length());
        if (firstSlash < 0) {
            this.server = url.substring(this.protocol.length());
            this.path = "/";
        } else {
            this.server = url.substring(this.protocol.length(), firstSlash);
            this.path = url.substring(firstSlash);
        }
        int portStart = this.server.indexOf(":");
        if (portStart > 0) {
            this.port = this.server.substring(portStart);
            this.server = this.server.substring(0, portStart);
        }
        this.requestHeader.put("Host", String.valueOf(this.server) + this.port);
    }

    private void createSocket() throws IOException {
        Log.trace(this, "createSocket socket://" + this.server + this.port);
        this.socket = (SocketConnection)Connector.open((String)("socket://" + this.server + this.port), (int)3);
    }

    public static HttpConnection_1_0 open(String url) throws IOException {
        HttpConnection_1_0 connection = new HttpConnection_1_0(url);
        connection.createSocket();
        return connection;
    }

    public int getResponseCode() throws IOException {
        if (this.responseCode == -1) {
            this.readResponse();
        }
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        if (this.responseCode == -1) {
            this.readResponse();
        }
        return this.responseMessage;
    }

    public void setRequestMethod(String requestMethod) throws IOException {
        if (!requestMethod.equals(POST)) {
            throw new RuntimeException("HttpConnection_1_0 - Only POST is supported");
        }
        this.requestMethod = POST;
    }

    public void setRequestProperty(String name, String value) throws IOException {
        Log.trace(this, "setRequestProperty: " + name + ":" + value);
        this.requestHeader.put(name, value);
    }

    public long getLength() {
        if (this.responseCode == -1) {
            try {
                this.readResponse();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        long length = -1L;
        try {
            length = Long.parseLong((String)this.responseHeader.get("Content-Length"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Log.trace(this, "getLength: " + length);
        return length;
    }

    public InputStream openInputStream() throws IOException {
        Log.trace(this, "openInputStream");
        if (this.responseCode == -1) {
            this.readResponse();
        }
        return this.inputStream;
    }

    public void close() throws IOException {
        Log.trace(this, "close");
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public OutputStream openOutputStream() throws IOException {
        Log.trace(this, "openOutputStream");
        String http_header = "";
        this.outputStream = this.socket.openOutputStream();
        String requestLine = String.valueOf(this.requestMethod) + " " + this.path + " " + "HTTP/1.0" + "\r\n";
        this.outputStream.write(requestLine.getBytes());
        http_header = String.valueOf(http_header) + requestLine;
        Enumeration e = this.requestHeader.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.requestHeader.get(key);
            String headerLine = String.valueOf(key) + ": " + value + "\r\n";
            http_header = String.valueOf(http_header) + headerLine;
            this.outputStream.write(headerLine.getBytes());
        }
        this.outputStream.write("\r\n".getBytes());
        http_header = String.valueOf(http_header) + "\r\n";
        Log.trace(this, "openOutputStream opened and sent: " + http_header);
        return this.outputStream;
    }

    private void readResponse() throws IOException {
        Log.trace(this, "readResponse");
        this.inputStream = this.socket.openInputStream();
        this.readStatusLine(this.inputStream);
        this.readResponseHeader(this.inputStream);
    }

    private void readStatusLine(InputStream is) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int character = 0;
        int[] statusEnd = new int[]{13, 10};
        int statusEndIndex = 0;
        while ((character = is.read()) != -1) {
            int n = statusEndIndex = character == statusEnd[statusEndIndex] ? statusEndIndex + 1 : 0;
            if (statusEndIndex == 2) {
                buffer.deleteCharAt(buffer.length() - 1);
                break;
            }
            buffer.append((char)character);
        }
        String statusLine = buffer.toString();
        Log.trace(this, "readStatusLine : " + statusLine);
        int firstSpace = statusLine.indexOf(" ");
        int secondSpace = statusLine.indexOf(" ", firstSpace + 1);
        if (firstSpace == -1 || secondSpace == -1) {
            throw new IOException("Invalid format on server response in status line.");
        }
        this.responseCode = Integer.parseInt(statusLine.substring(firstSpace + 1, secondSpace));
        this.responseMessage = statusLine.substring(secondSpace + 1);
        Log.trace(this, "readStatusLine  response code = " + this.responseCode + "; response message = " + this.responseMessage);
    }

    private void readResponseHeader(InputStream is) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int character = 0;
        int[] headerEnd = new int[]{13, 10, 13, 10};
        int headerEndIndex = 0;
        while ((character = is.read()) != -1) {
            int n = headerEndIndex = character == headerEnd[headerEndIndex] ? headerEndIndex + 1 : 0;
            if (headerEndIndex == 2) {
                buffer.deleteCharAt(buffer.length() - 1);
                String headerLine = buffer.toString();
                int divider = headerLine.indexOf(":");
                if (divider > 0) {
                    String key = headerLine.substring(0, divider);
                    String value = headerLine.substring(divider + 1);
                    this.responseHeader.put(key, value.trim());
                }
                buffer = new StringBuffer();
                continue;
            }
            if (headerEndIndex == 4) break;
            buffer.append((char)character);
        }
        Enumeration e = this.responseHeader.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.responseHeader.get(key);
            Log.trace(this, "readResponseHeader header: " + key + ":" + value);
        }
    }

    public String getType() {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public DataInputStream openDataInputStream() throws IOException {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public String getEncoding() {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public long getDate() throws IOException {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public long getExpiration() throws IOException {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public String getFile() {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public String getHeaderField(int arg0) throws IOException {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public String getHeaderField(String arg0) throws IOException {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public long getHeaderFieldDate(String arg0, long arg1) throws IOException {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public int getHeaderFieldInt(String arg0, int arg1) throws IOException {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public String getHeaderFieldKey(int arg0) throws IOException {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public String getHost() {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public long getLastModified() throws IOException {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public int getPort() {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public String getProtocol() {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public String getQuery() {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public String getRef() {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public String getRequestMethod() {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public String getRequestProperty(String arg0) {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public String getURL() {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        throw new RuntimeException("HttpConnection_1_0 - Not implemented");
    }
}

