/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.example;

import com.sonyericsson.example.Satellite;
import java.util.Vector;

public class NMEAUtil {
    private static String stripNmea(String nmea) {
        return nmea.substring(nmea.indexOf(44) + 1, nmea.indexOf(42));
    }

    private static String removeNewlines(String s) {
        StringBuffer sb = new StringBuffer();
        char[] arr = s.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == '\n' || arr[i] == '\r') continue;
            sb.append(arr[i]);
        }
        return new String(sb);
    }

    private static String insertZeros(String s, char token) {
        StringBuffer sb = new StringBuffer();
        char[] arr = s.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0 && arr[i] == token && arr[i - 1] == token) {
                sb.append('0');
                sb.append(token);
                continue;
            }
            sb.append(arr[i]);
        }
        if (arr[arr.length - 1] == token) {
            sb.append('0');
        }
        return new String(sb);
    }

    private static String[] split(String s, char token) {
        Vector<String> v = new Vector<String>();
        StringBuffer tmp = new StringBuffer();
        char[] arr = s.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == token && tmp.length() > 0) {
                v.addElement(new String(tmp));
                tmp = new StringBuffer();
                continue;
            }
            if (arr[i] == token) continue;
            tmp.append(arr[i]);
        }
        v.addElement(new String(tmp));
        Object[] strArr = new String[v.size()];
        v.copyInto(strArr);
        return strArr;
    }

    private static void parseString(String sentance, Vector output) {
        String tmp = NMEAUtil.stripNmea(sentance);
        tmp = NMEAUtil.insertZeros(tmp, ',');
        String[] arr = NMEAUtil.split(tmp, ',');
        for (int i = 3; i < arr.length - 3; i += 4) {
            Satellite sat = new Satellite();
            sat.prn = Integer.parseInt(arr[i]);
            sat.elev = Integer.parseInt(arr[i + 1]);
            sat.azim = Integer.parseInt(arr[i + 2]);
            sat.snr = Integer.parseInt(arr[i + 3]);
            output.addElement(sat);
        }
    }

    public static Vector parseNmea(String nmea) {
        String strippedNmea = NMEAUtil.removeNewlines(nmea);
        String[] sentance = NMEAUtil.split(strippedNmea, '$');
        Vector satellites = new Vector();
        for (int i = 0; i < sentance.length; ++i) {
            NMEAUtil.parseString(sentance[i], satellites);
        }
        return satellites;
    }
}

