/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.example;

import com.sonyericsson.example.GPSTestApp;
import com.sonyericsson.example.LocationProviderAdapter;
import com.sonyericsson.example.PositioningListener;
import com.sonyericsson.example.Utils;
import javax.microedition.lcdui.StringItem;
import javax.microedition.location.Location;
import javax.microedition.location.LocationListener;
import javax.microedition.location.LocationProvider;

public class PositioningRunner
implements Runnable {
    private volatile boolean running = true;
    private final PositioningListener plistener;
    private LocationProvider lp;
    private long subscrStart = 0L;
    private long timeToFirstFix = 0L;
    private StringItem s1;
    private final GPSTestApp app;

    public PositioningRunner(GPSTestApp midlet, StringItem s1) {
        this.s1 = s1;
        this.plistener = new PositioningListener();
        this.lp = LocationProviderAdapter.getLocationProvider();
        this.app = midlet;
    }

    public void showStatusMessage(String s) {
        this.s1.setText(s);
    }

    public void init() {
        this.s1.setText("Acquiring GPS fix");
        this.subscrStart = System.currentTimeMillis();
        try {
            this.lp.setLocationListener((LocationListener)this.plistener, 1, -1, -1);
        }
        catch (SecurityException s) {
            this.app.exitMIDlet();
        }
        this.running = true;
    }

    public void quit() {
        this.running = false;
        this.lp.setLocationListener(null, -1, -1, -1);
    }

    public void run() {
        boolean firstFixTimeSaved = false;
        while (this.running) {
            StringBuffer sb = new StringBuffer("");
            Location l = this.plistener.waitForLocation();
            if (l.isValid()) {
                if (!firstFixTimeSaved) {
                    this.timeToFirstFix = System.currentTimeMillis() - this.subscrStart;
                    firstFixTimeSaved = true;
                }
                sb.append("Time to first fix: " + this.timeToFirstFix + "ms\n");
                sb.append("Location method: " + Utils.getLocationMethodString(l));
                sb.append("\n" + Utils.locationToString(l));
            } else {
                sb = new StringBuffer("Acquiring GPS fix");
            }
            this.s1.setText(new String(sb));
        }
    }
}

