/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.example;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Satellite {
    private static final int POSUI_GPSSTATUS_NORTH = 0;
    private static final int POSUI_GPSSTATUS_EAST = 90;
    private static final int POSUI_GPSSTATUS_SOUTH = 180;
    private static final int POSUI_GPSSTATUS_WEST = 270;
    private final int SAT_WIDTH = Font.getDefaultFont().stringWidth("00") + 4;
    private final int SAT_HEIGHT = Font.getDefaultFont().stringWidth("00") + 4;
    int prn;
    int elev;
    int azim;
    int snr;

    public void paint(Graphics g, int center_x, int center_y) {
        int x = 0;
        int y = 0;
        int satCircleRadius = (int)((double)g.getClipWidth() * 0.3);
        double elevationRad = (double)this.elev * Math.PI / 180.0;
        double elevation = Math.cos(elevationRad) * (double)satCircleRadius;
        double angle = 0.0;
        if (this.elev > 0) {
            if (this.azim <= 90) {
                angle = this.azim;
            } else if (this.azim > 90 && this.azim <= 180) {
                angle = 180 - this.azim;
            } else if (this.azim > 180 && this.azim <= 270) {
                angle = this.azim - 180;
            } else if (this.azim > 270) {
                angle = 360 - this.azim;
            }
            angle = angle * Math.PI / 180.0;
            double sinVal = Math.sin(angle);
            double cosVal = Math.cos(angle);
            y = this.azim < 90 || this.azim > 270 ? (int)((double)center_y - cosVal * elevation) : (int)(cosVal * elevation + (double)center_y);
            x = this.azim < 180 ? (int)(sinVal * elevation + (double)center_x) : (int)((double)center_x - sinVal * elevation);
        }
        if (x != 0 || y != 0) {
            if (this.snr == 0) {
                g.setColor(-5592406);
            } else {
                g.setColor(0x5555AA55);
            }
            g.fillArc((int)this.round((double)x - (double)this.SAT_WIDTH / 2.0), (int)this.round(y - this.SAT_HEIGHT / 2), this.SAT_WIDTH, this.SAT_HEIGHT, 0, 360);
            String snrStr = "" + this.snr;
            int strOffsetX = (int)this.round((double)g.getFont().stringWidth(snrStr) / 2.0);
            int strOffsetY = (int)this.round((double)g.getFont().getHeight() / 2.0);
            g.setColor(-1);
            g.drawString(snrStr, x - strOffsetX, y - strOffsetY, 20);
        }
    }

    private double round(double d) {
        boolean pos;
        double floor = Math.floor(d);
        boolean bl = pos = d >= 0.0;
        if (Math.abs(d) - Math.floor(Math.abs(d)) >= 0.5) {
            return pos ? floor + 1.0 : floor - 1.0;
        }
        return floor;
    }

    public String toString() {
        return "SAT:" + this.prn + ":" + this.elev + ":" + this.azim + ":" + this.snr;
    }
}

