/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.example;

import com.sonyericsson.example.GPSTestApp;
import com.sonyericsson.example.Satellite;
import com.sonyericsson.example.SatelliteModel;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.location.Location;
import javax.microedition.location.QualifiedCoordinates;

public class SatelliteCanvas
extends Canvas
implements CommandListener {
    private Vector satellites;
    private Command okCommand = new Command("Back", 2, 0);
    private Command minimizeCommand = new Command("Minimize", 4, 0);
    private GPSTestApp midlet;
    private SatelliteModel model;
    private Location currentLocation;
    private static final Font smallFont = Font.getFont((int)0, (int)0, (int)8);

    public SatelliteCanvas(GPSTestApp midlet, SatelliteModel model) {
        this.addCommand(this.okCommand);
        this.addCommand(this.minimizeCommand);
        this.setCommandListener(this);
        this.midlet = midlet;
        this.model = model;
    }

    void setLocation(Location l) {
        this.currentLocation = l;
    }

    void setSateliteState(Vector sats) {
        this.satellites = sats;
    }

    private double truncate(double d) {
        int tmp = (int)(d * 1.0E7);
        double res = (double)tmp / 1.0E7;
        return res;
    }

    void drawLocationcoords(Graphics g) {
        String hAcc;
        String altStr;
        String speedStr;
        String lonStr;
        String latStr;
        g.setColor(-16777216);
        g.setFont(smallFont);
        QualifiedCoordinates q = this.currentLocation.getQualifiedCoordinates();
        if (this.currentLocation.isValid()) {
            latStr = "Lat: " + this.truncate(q.getLatitude());
            lonStr = "Lon: " + this.truncate(q.getLongitude());
            speedStr = "Speed: " + (int)this.currentLocation.getSpeed() + "m/s";
            altStr = "Alt: " + (int)q.getAltitude() + "m";
            hAcc = "HAcc: " + (int)q.getHorizontalAccuracy() + "m";
        } else {
            latStr = "Lat: -";
            lonStr = "Lon: -";
            speedStr = "Speed: -";
            altStr = "Altitude: -";
            hAcc = "HAcc: -";
        }
        g.drawString(latStr, 0, 0, 20);
        g.drawString(lonStr, 0, smallFont.getHeight(), 20);
        g.drawString(altStr, 0, g.getClipHeight() - 2 * smallFont.getHeight(), 20);
        g.drawString(speedStr, 0, g.getClipHeight() - smallFont.getHeight(), 20);
        int hacOffset = smallFont.charsWidth(speedStr.toCharArray(), 0, speedStr.length()) + 10;
        g.drawString(hAcc, hacOffset, g.getClipHeight() - smallFont.getHeight(), 20);
        g.setFont(Font.getDefaultFont());
    }

    public void paint(Graphics g) {
        g.setColor(-1);
        g.fillRect(0, 0, g.getClipWidth(), g.getClipHeight());
        int diam0 = (int)((double)g.getClipWidth() * 0.8);
        int diam1 = (int)((double)g.getClipWidth() * 0.6);
        int diam2 = (int)((double)g.getClipWidth() * 0.6 * 0.7);
        int diam3 = (int)((double)g.getClipWidth() * 0.6 * 0.6 * 0.6);
        int circle_0_x = g.getClipWidth() / 2 - diam0 / 2;
        int circle_1_x = g.getClipWidth() / 2 - diam1 / 2;
        int circle_2_x = g.getClipWidth() / 2 - diam2 / 2;
        int circle_3_x = g.getClipWidth() / 2 - diam3 / 2;
        int circle_0_y = g.getClipHeight() / 2 - diam0 / 2;
        int circle_1_y = g.getClipHeight() / 2 - diam1 / 2;
        int circle_2_y = g.getClipHeight() / 2 - diam2 / 2;
        int circle_3_y = g.getClipHeight() / 2 - diam3 / 2;
        g.setColor(-8355712);
        g.fillArc(circle_0_x, circle_0_y, diam0, diam0, 0, 360);
        g.setColor(-6710887);
        g.fillArc(circle_1_x, circle_1_y, diam1, diam1, 0, 360);
        g.setColor(-5592406);
        g.fillArc(circle_2_x, circle_2_y, diam2, diam2, 0, 360);
        g.setColor(-2236963);
        g.fillArc(circle_3_x, circle_3_y, diam3, diam3, 0, 360);
        g.setColor(-1);
        if (this.satellites != null) {
            for (int i = 0; i < this.satellites.size(); ++i) {
                Satellite sat = (Satellite)this.satellites.elementAt(i);
                sat.paint(g, g.getClipWidth() / 2, g.getClipHeight() / 2);
            }
            this.drawLocationcoords(g);
        } else {
            g.setColor(-16777216);
            g.drawString("Searching...", 0, 0, 20);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.equals(this.okCommand)) {
            this.model.quit();
            this.midlet.switchDisplayable(null, (Displayable)this.midlet.getList());
        } else if (command.equals(this.minimizeCommand)) {
            this.midlet.getDisplay().setCurrent(null);
        }
    }
}

