/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.example;

import com.sonyericsson.example.GPSTestApp;
import com.sonyericsson.example.LocationProviderAdapter;
import com.sonyericsson.example.NMEAUtil;
import com.sonyericsson.example.PositioningListener;
import com.sonyericsson.example.SatelliteCanvas;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.location.Location;
import javax.microedition.location.LocationListener;
import javax.microedition.location.LocationProvider;

public class SatelliteModel {
    private PositioningListener posListener;
    private LocationProvider lp;
    private final SatelliteCanvas canvas;
    private volatile boolean quit = false;
    private final GPSTestApp app;

    SatelliteModel(GPSTestApp midlet) {
        this.canvas = new SatelliteCanvas(midlet, this);
        this.app = midlet;
    }

    void quit() {
        this.quit = true;
    }

    Canvas getView() {
        return this.canvas;
    }

    void start() {
        new Thread(new Runnable(){

            public void run() {
                SatelliteModel.this.handleLocationUpdates();
            }
        }).start();
    }

    private void drawSatellites(String nmea, Location l) {
        Vector satellites = NMEAUtil.parseNmea(nmea);
        this.canvas.setSateliteState(satellites);
        this.canvas.setLocation(l);
        this.canvas.repaint();
    }

    public void init() {
        this.posListener = new PositioningListener();
        this.lp = LocationProviderAdapter.getLocationProvider();
        try {
            this.lp.setLocationListener((LocationListener)this.posListener, 1, -1, -1);
        }
        catch (SecurityException s) {
            this.app.exitMIDlet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLocationUpdates() {
        try {
            while (!this.quit) {
                Location l = this.posListener.waitForLocation();
                String nmea = l.getExtraInfo("application/X-jsr179-location-nmea");
                if (nmea == null || nmea.length() <= 0) continue;
                this.drawSatellites(nmea, l);
            }
        }
        catch (SecurityException s) {
            System.out.println("Catch ex: " + s);
            this.app.exitMIDlet();
        }
        finally {
            if (this.lp != null) {
                this.lp.setLocationListener(null, -1, -1, -1);
            }
        }
    }
}

