/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.example;

import java.util.Date;
import javax.microedition.location.Location;
import javax.microedition.location.QualifiedCoordinates;

class Utils {
    Utils() {
    }

    public static String getStateString(int locationProviderState) {
        String str;
        switch (locationProviderState) {
            case 1: {
                str = "AVAILABLE";
                break;
            }
            case 2: {
                str = "TEMPORARILY_UNAVAILABLE";
                break;
            }
            case 3: {
                str = "OUT_OF_SERVICE";
                break;
            }
            default: {
                throw new IllegalArgumentException("Error : unknown state:" + locationProviderState);
            }
        }
        return str;
    }

    public static String locationToString(Location l) {
        if (l == null) {
            return "location == null!";
        }
        QualifiedCoordinates q = l.getQualifiedCoordinates();
        if (q == null) {
            return "QualifiedCoordinates == null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Position: (lat, lon, alt, hac, spd, date):\n");
        sb.append(q.getLatitude());
        sb.append(", ");
        sb.append(q.getLongitude());
        sb.append(", ");
        sb.append(q.getAltitude());
        sb.append("m, ");
        sb.append(q.getHorizontalAccuracy());
        sb.append(", ");
        sb.append(l.getSpeed());
        sb.append("m/s");
        sb.append("\n");
        sb.append(new Date(l.getTimestamp()).toString());
        return new String(sb);
    }

    public static String getLocationMethodString(Location l) {
        StringBuffer sb = new StringBuffer();
        int locMethod = l.getLocationMethod();
        if ((locMethod & 0x40000) != 0) {
            sb.append("MTA_ASSISTED");
        }
        if ((locMethod & 0x80000) != 0) {
            sb.append("MTA_UNASSISTED");
        }
        if ((locMethod & 8) != 0) {
            sb.append("\nMTE_CELLID");
        }
        if ((locMethod & 1) != 0) {
            sb.append("\nMTE_SATELLITE");
        }
        if ((locMethod & 0x20000) != 0) {
            sb.append("\nMTY_NETWORKBASED");
        }
        if ((locMethod & 0x10000) != 0) {
            sb.append("\nMTY_TERMINALBASED");
        }
        return new String(sb);
    }
}

