/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.service.action.ActionUtil;
import com.sonyericsson.picasaweb.service.config.Config;
import com.sonyericsson.picasaweb.service.http.Authentication;
import com.sonyericsson.picasaweb.service.http.UpdateContentRequest;
import com.sonyericsson.picasaweb.service.http.UploadContentRequest;
import com.sonyericsson.picasaweb.service.http.UrlFactory;
import com.sonyericsson.picasaweb.service.xml.ContentParser;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.model.UploadItem;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.service.transfer.TransferJob;
import com.sonyericsson.webalbum.service.transfer.TransferRequestProgressListener;
import com.sonyericsson.webalbum.util.IOUtil;
import com.sonyericsson.webalbum.util.MediaUtil;
import com.sonyericsson.webalbum.util.MimeUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.media.MediaException;

public class UploadJob
extends TransferJob
implements TransferRequestProgressListener {
    private static final int UPLOAD_PROGRESS_INTERVAL = 10240;
    private String baseDir;
    private String authToken;

    protected UploadJob(int id, UploadItem[] items, String authToken, String baseDir) {
        super(id, items);
        this.authToken = authToken;
        this.baseDir = baseDir;
    }

    /*
     * Loose catch block
     */
    private int uploadItem(UploadItem item) {
        int result;
        block31: {
            String tempUrl;
            InputStream is;
            FileConnection fc;
            block30: {
                result = 0;
                Content content = (Content)item.getEntry();
                fc = null;
                is = null;
                tempUrl = null;
                try {
                    int maxWidthOrHeight;
                    Log.trace("UploadJob#uploadContent: Starting upload");
                    String albumId = content.getAlbumId();
                    if (albumId == null) {
                        throw new ServiceException(4);
                    }
                    String requestUrl = UrlFactory.createAddContentUrl(albumId);
                    Resource resource = content.getResource("content");
                    if (resource == null) {
                        throw new ServiceException(2);
                    }
                    String localUrl = resource.getLocalUrl();
                    if (localUrl == null) {
                        throw new ServiceException(2);
                    }
                    String contentType = MimeUtil.getContentTypeFromUrl(localUrl);
                    if ("image/jpeg".equals(contentType) && MediaUtil.resizeImage(localUrl, contentType, maxWidthOrHeight = Math.min(1600, Config.getPhotoUploadSize()), tempUrl = this.createTempUrl(localUrl))) {
                        localUrl = tempUrl;
                    }
                    int fileSize = IOUtil.getFileSize(localUrl);
                    item.setTotalNrBytes(fileSize);
                    fc = (FileConnection)Connector.open((String)localUrl);
                    is = fc.openInputStream();
                    ContentParser entryParser = new ContentParser(0, 1, "/entry", null);
                    Log.trace("UploadJob#uploadPhoto: making request");
                    this.currentRequest = new UploadContentRequest(requestUrl, Authentication.createHeaders(this.authToken), is, contentType, entryParser);
                    this.currentRequest.setTransferRequestProgressListener(this, 10240);
                    if (this.cancelled) {
                        this.currentRequest.cancel();
                    } else {
                        ActionUtil.doHttpRequest(this.currentRequest);
                    }
                    if (this.currentRequest.isCancelled()) break block30;
                    Entry uploadedEntry = entryParser.getFirstEntry();
                    if (uploadedEntry != null) {
                        String id = uploadedEntry.getId();
                        String editUrl = uploadedEntry.getEditUrl();
                        content.setId(id);
                        try {
                            UpdateContentRequest upr = new UpdateContentRequest(editUrl, Authentication.createHeaders(this.authToken), content);
                            ActionUtil.doHttpRequest(upr);
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                    item.setState(5);
                }
                catch (IOException e) {
                    item.setState(4);
                    Log.logException(e);
                    IOUtil.closeInputStream(is);
                    IOUtil.closeConnection(fc);
                    if (this.currentRequest != null) {
                        item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                        if (this.currentRequest.isCancelled()) {
                            item.setState(3);
                            result = 1;
                        }
                        this.currentRequest = null;
                    }
                    if (tempUrl != null) {
                        IOUtil.deleteFile(tempUrl);
                    }
                    break block31;
                }
                catch (ServiceException e) {
                    item.setState(4);
                    Log.logException(e);
                    result = e.getResult();
                    break block31;
                }
                catch (MediaException e) {
                    item.setState(4);
                    Log.logException((Exception)((Object)e));
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    IOUtil.closeInputStream(is);
                    IOUtil.closeConnection(fc);
                    if (this.currentRequest != null) {
                        item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                        if (this.currentRequest.isCancelled()) {
                            item.setState(3);
                            result = 1;
                        }
                        this.currentRequest = null;
                    }
                    if (tempUrl != null) {
                        IOUtil.deleteFile(tempUrl);
                    }
                    break block31;
                }
                {
                    finally {
                        IOUtil.closeInputStream(is);
                        IOUtil.closeConnection(fc);
                        if (this.currentRequest != null) {
                            item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                            if (this.currentRequest.isCancelled()) {
                                item.setState(3);
                                result = 1;
                            }
                            this.currentRequest = null;
                        }
                        if (tempUrl != null) {
                            IOUtil.deleteFile(tempUrl);
                        }
                    }
                }
            }
            IOUtil.closeInputStream(is);
            IOUtil.closeConnection((Connection)fc);
            if (this.currentRequest != null) {
                item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                if (this.currentRequest.isCancelled()) {
                    item.setState(3);
                    result = 1;
                }
                this.currentRequest = null;
            }
            if (tempUrl != null) {
                IOUtil.deleteFile(tempUrl);
            }
        }
        return result;
    }

    private String createTempUrl(String localUrl) {
        return String.valueOf(ActionUtil.getTempDir(this.baseDir)) + "/temp" + System.currentTimeMillis();
    }

    protected int transferCurrentItem() {
        UploadItem item = (UploadItem)this.getCurrentItem();
        item.setState(2);
        this.reportProgress();
        return this.uploadItem(item);
    }
}

