/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.http;

import com.sonyericsson.picasaweb.service.util.EntryUtil;
import com.sonyericsson.picasaweb.service.xml.CommentParser;
import com.sonyericsson.webalbum.http.HttpRequest;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Comment;
import com.sonyericsson.webalbum.xml.XmlEncoder;
import com.sonyericsson.webalbum.xml.XmlException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class AddCommentRequest
extends HttpRequest {
    private Comment comment;
    private CommentParser parser;

    private static String getUrl(String contentId) {
        String urlPart = EntryUtil.decodeContentId(contentId);
        StringBuffer sb = new StringBuffer();
        sb.append("http://picasaweb.google.com/data/feed/api/user/default");
        sb.append(urlPart);
        return sb.toString();
    }

    public AddCommentRequest(Hashtable headers, Comment comment, CommentParser parser) {
        super("POST", AddCommentRequest.getUrl(comment.getContentId()), headers);
        this.comment = comment;
        this.parser = parser;
        headers.put("Content-Type", "application/atom+xml");
    }

    public void writeBody(OutputStream os) throws IOException {
        XmlEncoder enc = new XmlEncoder(os);
        enc.startElement("entry", "xmlns='http://www.w3.org/2005/Atom'");
        enc.addElement("content", null, this.comment.getText());
        enc.addElement("category", "scheme='http://schemas.google.com/g/2005#kind' term='http://schemas.google.com/photos/2007#comment'");
        enc.endElement();
        enc.flush();
    }

    public void readResponseBody(InputStream is) throws IOException {
        if (this.getResponseCode() == 201) {
            try {
                this.parser.parse(is);
            }
            catch (XmlException e) {
                Log.logException(e);
            }
        }
    }
}

