/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.http;

import com.sonyericsson.webalbum.http.HttpRequest;
import com.sonyericsson.webalbum.model.Album;
import com.sonyericsson.webalbum.xml.XmlEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

public abstract class AlbumRequest
extends HttpRequest {
    protected Album album;

    protected AlbumRequest(String url, Hashtable headers, Album album) {
        super("POST", url, headers);
        headers.put("Content-Type", "application/atom+xml");
        this.album = album;
    }

    public void writeBody(OutputStream os) throws IOException {
        XmlEncoder enc = new XmlEncoder(os);
        String id = this.album.getId();
        enc.startElement("entry", "xmlns='http://www.w3.org/2005/Atom' xmlns:media='http://search.yahoo.com/mrss/' xmlns:gphoto='http://schemas.google.com/photos/2007'");
        enc.addElement("title", "type='text'", this.album.getTitle());
        enc.addElement("summary", "type='text'", this.album.getDescription());
        if (id != null) {
            enc.addElement("gphoto:id", null, id);
        }
        enc.addElement("gphoto:location", null, "location");
        String access = this.album.getAccess();
        String picasaAccess = "public".equals(access) ? "public" : ("contacts".equals(access) ? "protected" : "private");
        enc.addElement("gphoto:access", null, picasaAccess);
        enc.startElement("media:group");
        enc.endElement();
        enc.addElement("category", "scheme='http://schemas.google.com/g/2005#kind' term='http://schemas.google.com/photos/2007#album'");
        enc.endElement();
        enc.flush();
    }
}

