/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.util;

import com.sonyericsson.webalbum.util.StringUtil;

public abstract class EntryUtil {
    private static final String[] decodedPrefix = new String[]{"/albumid/", "/photoid/", "/commentid/"};
    private static final String[] encodedPrefix = new String[]{"", "-", "-"};

    private static String trimId(String s) {
        int i = 0;
        while (i < s.length()) {
            if (!Character.isDigit(s.charAt(i))) {
                return s.substring(0, i);
            }
            ++i;
        }
        return s;
    }

    private static String decodeEntryId(String entryId, int nrExpectedParts) {
        String urlPart = null;
        String[] parts = StringUtil.split(entryId, "-");
        if (parts.length == nrExpectedParts) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < parts.length) {
                sb.append(decodedPrefix[i]).append(parts[i]);
                ++i;
            }
            urlPart = sb.toString();
        }
        return urlPart;
    }

    private static String encodeEntryId(String urlPart, int nrExpectedParts) {
        String entryId = null;
        String[] parts = StringUtil.split(urlPart, "/");
        if (parts.length >= nrExpectedParts * 2) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < nrExpectedParts) {
                sb.append(encodedPrefix[i]).append(EntryUtil.trimId(parts[i * 2 + 1]));
                ++i;
            }
            entryId = sb.toString();
        }
        return entryId;
    }

    public static String decodeAlbumId(String albumId) {
        return EntryUtil.decodeEntryId(albumId, 1);
    }

    public static String decodeContentId(String photoId) {
        return EntryUtil.decodeEntryId(photoId, 2);
    }

    public static String decodeCommentId(String commentId) {
        return EntryUtil.decodeEntryId(commentId, 3);
    }

    public static String encodeAlbumId(String urlPart) {
        return EntryUtil.encodeEntryId(urlPart, 1);
    }

    public static String encodeContentId(String urlPart) {
        return EntryUtil.encodeEntryId(urlPart, 2);
    }

    public static String encodeCommentId(String urlPart) {
        return EntryUtil.encodeEntryId(urlPart, 3);
    }
}

