/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.webalbum.codec;

import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.AttributeCodec;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Album;
import com.sonyericsson.webalbum.model.Entry;

public class AlbumCodec
extends EntryCodec {
    public static final String ITEM_TYPE = "album";
    public static final String ATTR_TITLE = ":title";
    public static final String ATTR_DESCRIPTION = ":description";
    public static final String ATTR_ACCESS = ":access";

    public AlbumCodec() {
        super(ITEM_TYPE);
    }

    protected Entry createEntry() {
        return new Album();
    }

    protected void decodeEntry(Attributes attr, Entry entry) {
        super.decodeEntry(attr, entry);
        Album album = (Album)entry;
        Log.trace("AlbumCodec.decodeEntry()");
        album.setTitle(AttributeCodec.decodeAttribute(attr.get("album:title")));
        album.setDescription(AttributeCodec.decodeAttribute(attr.get("album:description")));
        album.setAccess(attr.get("album:access"));
    }

    protected void encodeEntry(Entry entry, Attributes attr) {
        super.encodeEntry(entry, attr);
        Album album = (Album)entry;
        Log.trace("AlbumCodec.encodeEntry()");
        attr.set("album:title", AttributeCodec.encodeAttribute(album.getTitle()));
        attr.set("album:description", AttributeCodec.encodeAttribute(album.getDescription()));
        attr.set("album:access", album.getAccess());
        this.encodeResource(entry, "cover-image", attr);
    }
}

