/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.webalbum.util;

import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.util.IOUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public abstract class CacheUtil {
    private static final String USED_MARKER = ".used";
    private static String cacheDirUrl;

    private static String hashMD5(String s) {
        String result = null;
        try {
            byte[] input = s.getBytes("UTF-8");
            byte[] output = new byte[16];
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(input, 0, input.length);
            int outputLength = md.digest(output, 0, output.length);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < outputLength) {
                sb.append(Integer.toHexString(output[i] & 0xFF));
                ++i;
            }
            result = sb.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (DigestException digestException) {
            // empty catch block
        }
        return result;
    }

    private static FileConnection createFile(String fileUrl) throws IOException {
        FileConnection fc = null;
        try {
            fc = (FileConnection)Connector.open((String)fileUrl);
            if (fc.exists()) {
                fc.delete();
            }
            fc.create();
            return fc;
        }
        catch (IOException e) {
            IOUtil.closeConnection((Connection)fc);
            throw e;
        }
    }

    public static void setCacheDirUrl(String cacheDirUrl) {
        block6: {
            FileConnection fc = null;
            try {
                try {
                    fc = (FileConnection)Connector.open((String)cacheDirUrl);
                    if (!fc.exists()) {
                        Log.trace("Creating cache dir " + cacheDirUrl);
                        fc.mkdir();
                        fc.setHidden(true);
                    }
                    CacheUtil.cacheDirUrl = cacheDirUrl;
                }
                catch (IOException iOException) {
                    IOUtil.closeConnection((Connection)fc);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeConnection(fc);
                throw throwable;
            }
            IOUtil.closeConnection((Connection)fc);
        }
    }

    public static String getCacheDirUrl() {
        return cacheDirUrl;
    }

    public static String getCachedFileUrl(String remoteUrl) {
        String fileUrl = null;
        if (cacheDirUrl != null) {
            int lastSlashPos;
            int lastDotPos;
            StringBuffer sb = new StringBuffer();
            int startPos = 0;
            int endPos = remoteUrl.length();
            int schemePos = remoteUrl.indexOf("://");
            Log.trace("Getting cached file url for " + remoteUrl);
            if (schemePos >= 0) {
                startPos = schemePos + 3;
            }
            if ((lastDotPos = remoteUrl.lastIndexOf(46)) > (lastSlashPos = remoteUrl.lastIndexOf(47))) {
                endPos = lastDotPos;
            }
            sb.append(cacheDirUrl);
            sb.append(CacheUtil.hashMD5(remoteUrl.substring(startPos, endPos)));
            sb.append(remoteUrl.substring(endPos));
            fileUrl = sb.toString();
            Log.trace("Cached file url is " + fileUrl);
        }
        return fileUrl;
    }

    public static boolean cachedFileIsValid(String fileUrl) {
        boolean isValid;
        block5: {
            isValid = false;
            FileConnection fc = null;
            FileConnection fcUsed = null;
            Log.trace("Checking if cached file " + fileUrl + " is valid");
            try {
                try {
                    fc = (FileConnection)Connector.open((String)fileUrl);
                    fcUsed = (FileConnection)Connector.open((String)(String.valueOf(fileUrl) + USED_MARKER));
                    isValid = fc.exists() && fcUsed.exists();
                }
                catch (IOException iOException) {
                    IOUtil.closeConnection((Connection)fc);
                    IOUtil.closeConnection(fcUsed);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeConnection(fc);
                IOUtil.closeConnection(fcUsed);
                throw throwable;
            }
            IOUtil.closeConnection((Connection)fc);
            IOUtil.closeConnection((Connection)fcUsed);
        }
        return isValid;
    }

    public static FileConnection openCachedFile(String fileUrl) throws IOException {
        FileConnection fcUsed;
        FileConnection fc;
        block7: {
            fc = null;
            fcUsed = null;
            Log.trace("Trying to open cached file " + fileUrl);
            fc = (FileConnection)Connector.open((String)fileUrl);
            fcUsed = (FileConnection)Connector.open((String)(String.valueOf(fileUrl) + USED_MARKER));
            if (!fc.exists() || !fcUsed.exists()) break block7;
            try {
                fcUsed.delete();
                fcUsed.create();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            FileConnection fileConnection = fc;
            IOUtil.closeConnection((Connection)fcUsed);
            return fileConnection;
        }
        try {
            try {
                throw new IOException();
            }
            catch (IOException e) {
                IOUtil.closeConnection((Connection)fc);
                throw e;
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeConnection(fcUsed);
            throw throwable;
        }
    }

    public static FileConnection createCachedFile(String fileUrl) throws IOException {
        Log.trace("Creating cached file " + fileUrl);
        IOUtil.deleteFile(String.valueOf(fileUrl) + USED_MARKER);
        return CacheUtil.createFile(fileUrl);
    }

    public static void markCachedFileAsUsed(String fileUrl) {
        Log.trace("Marking cached file " + fileUrl + " as used");
        try {
            FileConnection fc = CacheUtil.createFile(String.valueOf(fileUrl) + USED_MARKER);
            IOUtil.closeConnection((Connection)fc);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void markCachedFileAsValid(String fileUrl) {
        Log.trace("Marking cached file " + fileUrl + " as valid");
        CacheUtil.markCachedFileAsUsed(fileUrl);
    }

    public static void trimCache(int goalSize) {
        block9: {
            if (cacheDirUrl != null) {
                FileConnection fc = null;
                Log.trace("Trimming cache");
                try {
                    try {
                        int index;
                        fc = (FileConnection)Connector.open((String)cacheDirUrl);
                        Enumeration fileNames = fc.list();
                        int totalSize = 0;
                        Vector<CacheEntry> cacheEntries = new Vector<CacheEntry>();
                        while (fileNames.hasMoreElements()) {
                            String fileName = (String)fileNames.nextElement();
                            if (fileName.endsWith(USED_MARKER)) continue;
                            String fileUrl = String.valueOf(cacheDirUrl) + fileName;
                            int fileSize = IOUtil.getFileSize(fileUrl);
                            long modifiedTime = IOUtil.getModifiedTime(String.valueOf(fileUrl) + USED_MARKER);
                            CacheEntry cacheEntry = new CacheEntry(fileUrl, fileSize, modifiedTime);
                            Log.trace("New CacheEntry: " + fileUrl + ", " + fileSize + ", " + modifiedTime);
                            index = 0;
                            while (index < cacheEntries.size()) {
                                if (((CacheEntry)cacheEntries.elementAt((int)index)).modifiedTime > modifiedTime) break;
                                ++index;
                            }
                            Log.trace("Inserting cache entry at index " + index);
                            cacheEntries.insertElementAt(cacheEntry, index);
                            totalSize += fileSize;
                        }
                        Log.info("Trimming cache - current size = " + totalSize + ", goal size = " + goalSize);
                        index = 0;
                        while (index < cacheEntries.size() && totalSize > goalSize) {
                            CacheEntry cacheEntry = (CacheEntry)cacheEntries.elementAt(index);
                            Log.trace("Deleting " + cacheEntry.fileUrl);
                            IOUtil.deleteFile(cacheEntry.fileUrl);
                            IOUtil.deleteFile(String.valueOf(cacheEntry.fileUrl) + USED_MARKER);
                            totalSize -= cacheEntry.fileSize;
                            ++index;
                        }
                        Log.info("Size after trimming = " + totalSize);
                    }
                    catch (IOException iOException) {
                        IOUtil.closeConnection((Connection)fc);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.closeConnection(fc);
                    throw throwable;
                }
                IOUtil.closeConnection((Connection)fc);
            }
        }
    }

    private static class CacheEntry {
        public String fileUrl;
        public int fileSize;
        public long modifiedTime;

        public CacheEntry(String fileUrl, int fileSize, long modifiedTime) {
            this.fileUrl = fileUrl;
            this.fileSize = fileSize;
            this.modifiedTime = modifiedTime;
        }
    }
}

