/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.webalbum.util;

import com.sonyericsson.webalbum.util.StringCodec;
import com.sonyericsson.webalbum.util.StringMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class StringUtil {
    private static int decodeKeyValue(String s, String separator, StringMap map, StringCodec codec) throws UnsupportedEncodingException {
        int nameStartPos = 0;
        int valueStartPos = s.indexOf(61) + 1;
        int valueEndPos = s.indexOf(separator, valueStartPos);
        while (valueStartPos > nameStartPos && valueEndPos > valueStartPos) {
            String name = s.substring(nameStartPos, valueStartPos - 1).trim();
            String value = s.substring(valueStartPos, valueEndPos).trim();
            if (codec != null) {
                name = codec.decode(name);
                value = codec.decode(value);
            }
            map.put(name, value);
            nameStartPos = valueEndPos + separator.length();
            valueStartPos = s.indexOf(61, nameStartPos + 1) + 1;
            valueEndPos = s.indexOf(separator, valueStartPos);
        }
        return nameStartPos;
    }

    public static StringMap decodeKeyValueString(String s, String separator, StringCodec codec) throws UnsupportedEncodingException {
        StringMap map = new StringMap();
        StringUtil.decodeKeyValue(s, separator, map, codec);
        return map;
    }

    public static String encodeKeyValueString(StringMap map, String separator, StringCodec codec) throws UnsupportedEncodingException {
        Enumeration keys = map.keys();
        StringBuffer sb = new StringBuffer();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String value = map.get(name);
            if (codec != null) {
                name = codec.encode(name);
                value = codec.encode(value);
            }
            sb.append(name).append("=").append(value);
            if (!keys.hasMoreElements()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String[] split(String s, String sep) {
        Vector<String> vector = new Vector<String>();
        int sepPos = -1;
        while ((sepPos = s.indexOf(sep)) >= 0) {
            if (sepPos > 0) {
                vector.addElement(s.substring(0, sepPos));
            }
            s = s.substring(sepPos + 1);
        }
        if (s.length() > 0) {
            vector.addElement(s);
        }
        String[] result = new String[vector.size()];
        int i = 0;
        while (i < vector.size()) {
            result[i] = (String)vector.elementAt(i);
            ++i;
        }
        return result;
    }

    public static StringMap splitKeyValue(InputStream is, String separator) throws IOException {
        StringMap map = new StringMap();
        byte[] bytes = new byte[128];
        int byteLength = 0;
        StringBuffer sb = new StringBuffer();
        while ((byteLength = is.read(bytes)) > 0) {
            sb.append(new String(bytes, 0, byteLength, "UTF-8"));
            int pos = StringUtil.decodeKeyValue(sb.toString(), separator, map, null);
            sb.delete(0, pos);
        }
        return map;
    }

    public static StringMap splitKeyValue(String s, String separator) {
        StringMap map = new StringMap();
        try {
            StringUtil.decodeKeyValue(s, separator, map, null);
        }
        catch (UnsupportedEncodingException e) {
            map = null;
        }
        return map;
    }
}

